/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import org.apache.nifi.minifi.bootstrap.MiNiFiStatus;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;

public class MiNiFiStatusProvider {
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final ProcessUtils processUtils;

    public MiNiFiStatusProvider(MiNiFiCommandSender miNiFiCommandSender, ProcessUtils processUtils) {
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.processUtils = processUtils;
    }

    public MiNiFiStatus getStatus(int port, long pid) {
        if (port == -1 && pid == -1L) {
            return new MiNiFiStatus();
        }
        boolean pingSuccess = false;
        if (port != -1) {
            pingSuccess = this.miNiFiCommandSender.isPingSuccessful(port);
        }
        if (pingSuccess) {
            return new MiNiFiStatus(port, pid, true, true);
        }
        return new MiNiFiStatus(port, pid, false, this.processUtils.isProcessRunning(pid));
    }
}

