/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.jpa.processor.core.mock.model;

import org.apache.olingo.odata2.jpa.processor.core.mock.model.JPAEdmMockData.EntityType.EntityTypeA;

public interface JPAEdmMockData {
  /*
   * Edm Complex Type Mock Data
   */
  public interface ComplexType {

    public interface ComplexTypeA {
      public static final String name = "ComplexTypeA";
      public static final Class<ComplexTypeA> clazz = ComplexTypeA.class;

      public interface Property {
        public static final String PROPERTY_A = "A";
        public static final String PROPERTY_B = "B";
        public static final String PROPERTY_C = "C";
      }

    }

    public interface ComplexTypeB {
      public static final String name = "ComplexTypeB";

      public interface Property {
        public static final String PROPERTY_D = "D";
        public static final String PROPERTY_E = "E";
      }

    }
  }

  public interface EntityType {
    public interface EntityTypeA {
      public static final String name = "SalesOrderHeader";
      public static final Class<EntityTypeA> entityClazz = EntityTypeA.class;

      public interface Property {
        public static final String PROPERTY_A = SimpleType.SimpleTypeA.NAME;

      }

    }
  }

  public interface SimpleType {
    public interface SimpleTypeA {
      public static final String NAME = "SOID";
      public static final Class<String> clazz = String.class;
      public static final Class<EntityTypeA> declaringClazz = EntityType.EntityTypeA.class;
    }
  }
}
