/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.util;

import java.io.IOException;
import org.apache.olingo.client.core.communication.util.PipedOutputStream;

public class PipedInputStream
extends java.io.PipedInputStream {
    final Object sync = new Object();
    byte[] buffer;
    boolean closed = false;
    int readLaps = 0;
    int readPosition = 0;
    PipedOutputStream source;
    int writeLaps = 0;
    int writePosition = 0;

    protected PipedInputStream() {
        this(null);
    }

    public PipedInputStream(PipedOutputStream source) {
        this(source, 0x400000);
    }

    public PipedInputStream(PipedOutputStream source, int bufferSize) {
        if (source != null) {
            try {
                this.connect(source);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.buffer = new byte[bufferSize];
    }

    @Override
    public int available() {
        return this.writePosition > this.readPosition ? this.writePosition - this.readPosition : (this.writePosition < this.readPosition ? this.buffer.length - this.readPosition + 1 + this.writePosition : (this.writeLaps > this.readLaps ? this.buffer.length : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        Object object = this.sync;
        synchronized (object) {
            this.closed = true;
            this.sync.notifyAll();
        }
    }

    public void connect(PipedOutputStream source) throws IOException {
        if (this.source != null) {
            throw new IOException("Pipe already connected");
        }
        this.source = source;
        source.sink = this;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[0];
        int result = this.read(b);
        return result == -1 ? -1 : b[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.writePosition == this.readPosition && this.writeLaps == this.readLaps) {
                if (this.closed) {
                    return -1;
                }
                try {
                    this.sync.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
                return this.read(b, off, len);
            }
            int amount = Math.min(len, (this.writePosition > this.readPosition ? this.writePosition : this.buffer.length) - this.readPosition);
            System.arraycopy(this.buffer, this.readPosition, b, off, amount);
            this.readPosition += amount;
            if (this.readPosition == this.buffer.length) {
                this.readPosition = 0;
                ++this.readLaps;
            }
            if (amount < len) {
                int second = this.read(b, off + amount, len - amount);
                int n = second == -1 ? amount : amount + second;
                return n;
            }
            this.sync.notifyAll();
            return amount;
        }
    }
}

