/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDuration;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeography;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyCollection;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyLineString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyMultiLineString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyMultiPoint;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyMultiPolygon;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyPoint;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeographyPolygon;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometry;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryCollection;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryLineString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryMultiLineString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryMultiPoint;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryMultiPolygon;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryPoint;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryPolygon;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;

public final class EdmPrimitiveTypeFactory {
    public static EdmPrimitiveType getInstance(EdmPrimitiveTypeKind kind) {
        switch (kind) {
            case Binary: {
                return EdmBinary.getInstance();
            }
            case Boolean: {
                return EdmBoolean.getInstance();
            }
            case Byte: {
                return EdmByte.getInstance();
            }
            case SByte: {
                return EdmSByte.getInstance();
            }
            case Date: {
                return EdmDate.getInstance();
            }
            case DateTimeOffset: {
                return EdmDateTimeOffset.getInstance();
            }
            case TimeOfDay: {
                return EdmTimeOfDay.getInstance();
            }
            case Duration: {
                return EdmDuration.getInstance();
            }
            case Decimal: {
                return EdmDecimal.getInstance();
            }
            case Single: {
                return EdmSingle.getInstance();
            }
            case Double: {
                return EdmDouble.getInstance();
            }
            case Guid: {
                return EdmGuid.getInstance();
            }
            case Int16: {
                return EdmInt16.getInstance();
            }
            case Int32: {
                return EdmInt32.getInstance();
            }
            case Int64: {
                return EdmInt64.getInstance();
            }
            case String: {
                return EdmString.getInstance();
            }
            case Stream: {
                return EdmStream.getInstance();
            }
            case Geography: {
                return EdmGeography.getInstance();
            }
            case GeographyPoint: {
                return EdmGeographyPoint.getInstance();
            }
            case GeographyLineString: {
                return EdmGeographyLineString.getInstance();
            }
            case GeographyPolygon: {
                return EdmGeographyPolygon.getInstance();
            }
            case GeographyMultiPoint: {
                return EdmGeographyMultiPoint.getInstance();
            }
            case GeographyMultiLineString: {
                return EdmGeographyMultiLineString.getInstance();
            }
            case GeographyMultiPolygon: {
                return EdmGeographyMultiPolygon.getInstance();
            }
            case GeographyCollection: {
                return EdmGeographyCollection.getInstance();
            }
            case Geometry: {
                return EdmGeometry.getInstance();
            }
            case GeometryPoint: {
                return EdmGeometryPoint.getInstance();
            }
            case GeometryLineString: {
                return EdmGeometryLineString.getInstance();
            }
            case GeometryPolygon: {
                return EdmGeometryPolygon.getInstance();
            }
            case GeometryMultiPoint: {
                return EdmGeometryMultiPoint.getInstance();
            }
            case GeometryMultiLineString: {
                return EdmGeometryMultiLineString.getInstance();
            }
            case GeometryMultiPolygon: {
                return EdmGeometryMultiPolygon.getInstance();
            }
            case GeometryCollection: {
                return EdmGeometryCollection.getInstance();
            }
        }
        throw new IllegalArgumentException("Wrong type: " + kind);
    }

    private EdmPrimitiveTypeFactory() {
    }
}

