/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.api.uri.queryoption.search.SearchTerm;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.parser.search.SearchBinaryImpl;
import org.apache.olingo.server.core.uri.parser.search.SearchParserException;
import org.apache.olingo.server.core.uri.parser.search.SearchTermImpl;
import org.apache.olingo.server.core.uri.parser.search.SearchUnaryImpl;
import org.apache.olingo.server.core.uri.queryoption.SearchOptionImpl;

public class SearchParser {
    public SearchOption parse(UriTokenizer tokenizer) throws SearchParserException {
        SearchOptionImpl searchOption = new SearchOptionImpl();
        searchOption.setSearchExpression(this.processExprOr(tokenizer));
        return searchOption;
    }

    private SearchExpression processExprOr(UriTokenizer tokenizer) throws SearchParserException {
        SearchExpression left = this.processExprAnd(tokenizer);
        while (tokenizer.next(UriTokenizer.TokenKind.OrOperatorSearch)) {
            SearchExpression right = this.processExprAnd(tokenizer);
            left = new SearchBinaryImpl(left, SearchBinaryOperatorKind.OR, right);
        }
        return left;
    }

    private SearchExpression processExprAnd(UriTokenizer tokenizer) throws SearchParserException {
        SearchExpression left = this.processTerm(tokenizer);
        while (tokenizer.next(UriTokenizer.TokenKind.AndOperatorSearch)) {
            SearchExpression right = this.processTerm(tokenizer);
            left = new SearchBinaryImpl(left, SearchBinaryOperatorKind.AND, right);
        }
        return left;
    }

    private SearchExpression processTerm(UriTokenizer tokenizer) throws SearchParserException {
        if (tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            ParserHelper.bws(tokenizer);
            SearchExpression expr = this.processExprOr(tokenizer);
            ParserHelper.bws(tokenizer);
            if (!tokenizer.next(UriTokenizer.TokenKind.CLOSE)) {
                throw new SearchParserException("Missing close parenthesis after open parenthesis.", SearchParserException.MessageKeys.MISSING_CLOSE, new String[0]);
            }
            return expr;
        }
        if (tokenizer.next(UriTokenizer.TokenKind.NotOperatorSearch)) {
            return this.processNot(tokenizer);
        }
        if (tokenizer.next(UriTokenizer.TokenKind.Word)) {
            return new SearchTermImpl(tokenizer.getText());
        }
        if (tokenizer.next(UriTokenizer.TokenKind.Phrase)) {
            return this.processPhrase(tokenizer);
        }
        throw new SearchParserException("Expected PHRASE or WORD not found.", SearchParserException.MessageKeys.EXPECTED_DIFFERENT_TOKEN, "PHRASE, WORD", "");
    }

    private SearchExpression processNot(UriTokenizer tokenizer) throws SearchParserException {
        if (tokenizer.next(UriTokenizer.TokenKind.Word)) {
            return new SearchUnaryImpl(new SearchTermImpl(tokenizer.getText()));
        }
        if (tokenizer.next(UriTokenizer.TokenKind.Phrase)) {
            return new SearchUnaryImpl(this.processPhrase(tokenizer));
        }
        throw new SearchParserException("NOT must be followed by a term.", SearchParserException.MessageKeys.INVALID_NOT_OPERAND, "");
    }

    private SearchTerm processPhrase(UriTokenizer tokenizer) {
        String literal = tokenizer.getText();
        return new SearchTermImpl(literal.substring(1, literal.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\"));
    }
}

