/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.FinderQueryImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FinderCache;
import org.apache.openjpa.kernel.FinderQuery;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.lib.conf.Configuration;

public class FinderCacheImpl
implements FinderCache<ClassMapping, SelectExecutor, Result> {
    private static final String PATTERN_SEPARATOR = "\\;";
    private static final String EXLUDED_BY_USER = "Excluded by user";
    private final Map<ClassMapping, FinderQuery<ClassMapping, SelectExecutor, Result>> _delegate;
    private final Map<String, String> _uncachables;
    private List<String> _exclusionPatterns;
    private QueryStatistics<ClassMapping> _stats;
    private ReentrantLock _lock = new ReentrantLock();
    private boolean _enableStats = false;

    public FinderCacheImpl() {
        this._delegate = new HashMap<ClassMapping, FinderQuery<ClassMapping, SelectExecutor, Result>>();
        this._uncachables = new HashMap<String, String>();
        this._stats = new QueryStatistics.None<ClassMapping>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMapView() {
        this.lock();
        try {
            TreeMap<String, String> view = new TreeMap<String, String>();
            for (ClassMapping mapping : this._delegate.keySet()) {
                view.put(mapping.getDescribedType().getName(), this._delegate.get(mapping).getQueryString());
            }
            TreeMap<String, String> treeMap = view;
            return treeMap;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public QueryStatistics<ClassMapping> getStatistics() {
        return this._stats;
    }

    @Override
    public FinderQuery<ClassMapping, SelectExecutor, Result> get(ClassMapping mapping, FetchConfiguration fetch) {
        if (fetch.getReadLockLevel() != 0) {
            return null;
        }
        if (!fetch.isFetchConfigurationSQLCacheAdmissible()) {
            return null;
        }
        boolean ignore = this.isHinted(fetch, "openjpa.hint.IgnoreFinder");
        boolean invalidate = this.isHinted(fetch, "openjpa.hint.InvalidateFinder");
        if (invalidate) {
            this.invalidate(mapping);
        }
        if (ignore) {
            return null;
        }
        FinderQuery<ClassMapping, SelectExecutor, Result> result = this._delegate.get(mapping);
        this._stats.recordExecution(mapping);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinderQuery<ClassMapping, SelectExecutor, Result> cache(ClassMapping mapping, SelectExecutor select, FetchConfiguration fetch) {
        this.lock();
        try {
            if (fetch.getReadLockLevel() != 0) {
                FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = null;
                return finderQuery;
            }
            if (!fetch.isFetchConfigurationSQLCacheAdmissible()) {
                FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = null;
                return finderQuery;
            }
            boolean recache = this.isHinted(fetch, "openjpa.hint.RecacheFinder");
            if (this.isExcluded(mapping)) {
                FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = recache ? this.put(mapping, select) : null;
                return finderQuery;
            }
            if (this._delegate.containsKey(mapping)) {
                FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = recache ? this.put(mapping, select) : this._delegate.get(mapping);
                return finderQuery;
            }
            FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = this.put(mapping, select);
            return finderQuery;
        }
        finally {
            this.unlock();
        }
    }

    private FinderQuery<ClassMapping, SelectExecutor, Result> put(ClassMapping mapping, SelectExecutor select) {
        FinderQueryImpl finder = FinderQueryImpl.newFinder(mapping, select);
        if (finder != null) {
            this._delegate.put(mapping, finder);
        } else {
            this.invalidate(mapping);
        }
        return finder;
    }

    @Override
    public boolean isExcluded(ClassMapping mapping) {
        return mapping != null && this.isExcluded(mapping.getDescribedType().getName());
    }

    @Override
    private boolean isExcluded(String target) {
        if (this._exclusionPatterns != null && this._exclusionPatterns.contains(target)) {
            return true;
        }
        return this.getMatchedExclusionPattern(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExclusionPattern(String pattern) {
        this.lock();
        try {
            if (this._exclusionPatterns == null) {
                this._exclusionPatterns = new ArrayList<String>();
            }
            this._exclusionPatterns.add(pattern);
            Collection<ClassMapping> invalidMappings = this.getMatchedKeys(pattern, this._delegate.keySet());
            for (ClassMapping invalidMapping : invalidMappings) {
                this.markUncachable(invalidMapping, pattern);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExclusionPattern(String pattern) {
        this.lock();
        try {
            if (this._exclusionPatterns == null) {
                return;
            }
            this._exclusionPatterns.remove(pattern);
            Collection<String> reborns = this.getMatchedKeys(pattern, (Collection<String>)this._uncachables.keySet());
            for (String rebornKey : reborns) {
                this._uncachables.remove(rebornKey);
            }
        }
        finally {
            this.unlock();
        }
    }

    private String getMatchedExclusionPattern(String id) {
        if (this._exclusionPatterns == null || this._exclusionPatterns.isEmpty()) {
            return null;
        }
        for (String pattern : this._exclusionPatterns) {
            if (!this.matches(pattern, id)) continue;
            return pattern;
        }
        return null;
    }

    private Collection<ClassMapping> getMatchedKeys(String pattern, Set<ClassMapping> set) {
        ArrayList<ClassMapping> result = new ArrayList<ClassMapping>();
        for (ClassMapping entry : set) {
            if (!this.matches(pattern, entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private Collection<String> getMatchedKeys(String pattern, Collection<String> coll) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : coll) {
            if (!this.matches(pattern, key)) continue;
            result.add(key);
        }
        return result;
    }

    boolean matches(String pattern, ClassMapping mapping) {
        return this.matches(pattern, mapping.getDescribedType().getName());
    }

    boolean matches(String pattern, String target) {
        return target != null && (target.equals(pattern) || target.matches(pattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invalidate(ClassMapping mapping) {
        this.lock();
        try {
            boolean bl = this._delegate.remove(mapping) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public FinderQuery<ClassMapping, SelectExecutor, Result> markUncachable(ClassMapping mapping) {
        return this.markUncachable(mapping.getDescribedType().getName());
    }

    @Override
    public FinderQuery<ClassMapping, SelectExecutor, Result> markUncachable(String id) {
        return this.markUncachable(id, EXLUDED_BY_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FinderQuery<ClassMapping, SelectExecutor, Result> markUncachable(String cls, String reason) {
        this.lock();
        try {
            boolean excludedByUser;
            boolean bl = excludedByUser = this._uncachables.get(cls) == EXLUDED_BY_USER;
            if (!excludedByUser) {
                this._uncachables.put(cls, reason);
            }
            FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = this._delegate.remove(this.searchMappingByName(cls));
            return finderQuery;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FinderQuery<ClassMapping, SelectExecutor, Result> markUncachable(ClassMapping mapping, String reason) {
        this.lock();
        try {
            boolean excludedByUser;
            String cls = mapping.getDescribedType().getName();
            boolean bl = excludedByUser = this._uncachables.get(cls) == EXLUDED_BY_USER;
            if (!excludedByUser) {
                this._uncachables.put(cls, reason);
            }
            FinderQuery<ClassMapping, SelectExecutor, Result> finderQuery = this._delegate.remove(mapping);
            return finderQuery;
        }
        finally {
            this.unlock();
        }
    }

    ClassMapping searchMappingByName(String cls) {
        for (ClassMapping mapping : this._delegate.keySet()) {
            if (!this.matches(cls, mapping)) continue;
            return mapping;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcludes(String excludes) {
        this.lock();
        try {
            String[] patterns;
            if (StringUtils.isEmpty(excludes)) {
                return;
            }
            if (this._exclusionPatterns == null) {
                this._exclusionPatterns = new ArrayList<String>();
            }
            for (String pattern : patterns = excludes.split(PATTERN_SEPARATOR)) {
                this.addExclusionPattern(pattern);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public List<String> getExcludes() {
        return this._exclusionPatterns == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._exclusionPatterns);
    }

    boolean isHinted(FetchConfiguration fetch, String hint) {
        if (fetch == null) {
            return false;
        }
        Object result = fetch.getHint(hint);
        return result != null && "true".equalsIgnoreCase(result.toString());
    }

    void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    void unlock() {
        if (this._lock != null && this._lock.isLocked()) {
            this._lock.unlock();
        }
    }

    public void setEnableStats(boolean b) {
        this._enableStats = b;
        if (this._enableStats) {
            this._stats = new QueryStatistics.Default<ClassMapping>();
        }
    }

    public boolean getEnableStats() {
        return this._enableStats;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void setConfiguration(Configuration conf) {
    }

    @Override
    public void endConfiguration() {
    }
}

