/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import com.ibm.websphere.jtaextensions.SynchronizationCallback;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.AsmAdaptor;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.NoTransactionException;
import serp.bytecode.BCClass;
import serp.bytecode.Project;

public class WASManagedRuntime
extends AbstractManagedRuntime
implements ManagedRuntime,
Configurable {
    private static final Localizer _loc = Localizer.forPackage(WASManagedRuntime.class);
    private Object _extendedTransaction = null;
    private Method _getGlobalId = null;
    private Method _registerSync = null;
    private OpenJPAConfiguration _conf = null;
    private Log _log = null;
    static final String CLASS = "org.apache.openjpa.ee.WASManagedRuntime$WASSynchronization";
    static final String INTERFACE = "com.ibm.websphere.jtaextensions.SynchronizationCallback";

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        return new WASTransaction();
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = (OpenJPAConfiguration)conf;
        this._log = this._conf.getLog("openjpa.Runtime");
    }

    @Override
    public void endConfiguration() {
        try {
            try (InitialContext ctx = new InitialContext();){
                this._extendedTransaction = ctx.lookup("java:comp/websphere/ExtendedJTATransaction");
            }
            Class<?> extendedJTATransaction = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction");
            Class<?> synchronizationCallback = Class.forName(INTERFACE);
            this._registerSync = extendedJTATransaction.getMethod("registerSynchronizationCallbackForCurrentTran", synchronizationCallback);
            this._getGlobalId = extendedJTATransaction.getMethod("getGlobalId", null);
        }
        catch (Exception e) {
            throw new InvalidStateException(_loc.get("was-reflection-exception"), (Object)e).setFatal(true);
        }
    }

    @Override
    public void startConfiguration() {
    }

    public static void main(String[] args) throws IOException {
        Project project = new Project();
        InputStream in = WASManagedRuntime.class.getClassLoader().getResourceAsStream(CLASS.replace('.', '/') + ".class");
        BCClass bcClass = project.loadClass(in);
        String[] interfaces = bcClass.getInterfaceNames();
        if (interfaces != null) {
            for (String anInterface : interfaces) {
                if (!anInterface.equals(INTERFACE)) continue;
                return;
            }
        }
        bcClass.declareInterface(INTERFACE);
        AsmAdaptor.write(bcClass);
    }

    @Override
    public void setRollbackOnly(Throwable cause) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    @Override
    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    static class WASSynchronization
    implements SynchronizationCallback {
        Synchronization _sync = null;

        WASSynchronization(Synchronization sync) {
            this._sync = sync;
        }

        public void afterCompletion(int localTransactionId, byte[] globalTransactionId, boolean committed) {
            if (this._sync != null) {
                if (committed) {
                    this._sync.afterCompletion(3);
                } else {
                    this._sync.afterCompletion(5);
                }
            }
        }

        public void beforeCompletion(int arg0, byte[] arg1) {
            if (this._sync != null) {
                this._sync.beforeCompletion();
            }
        }
    }

    class WASTransaction
    implements TransactionManager,
    Transaction {
        WASTransaction() {
        }

        @Override
        public int getStatus() throws SystemException {
            int rval;
            try {
                rval = this.getGlobalId() != null ? 0 : 6;
            }
            catch (Exception e) {
                throw new NoTransactionException(_loc.get("was-transaction-id-exception")).setCause(e);
            }
            return rval;
        }

        @Override
        public Transaction getTransaction() throws SystemException {
            return this;
        }

        @Override
        public void registerSynchronization(Synchronization arg0) throws IllegalStateException, RollbackException, SystemException {
            if (WASManagedRuntime.this._extendedTransaction != null) {
                try {
                    WASManagedRuntime.this._registerSync.invoke(WASManagedRuntime.this._extendedTransaction, new WASSynchronization(arg0));
                }
                catch (Exception e) {
                    throw new InvalidStateException(_loc.get("was-reflection-exception")).setCause(e);
                }
            } else {
                throw new InvalidStateException(_loc.get("was-lookup-error"));
            }
        }

        private byte[] getGlobalId() {
            try {
                return (byte[])WASManagedRuntime.this._getGlobalId.invoke(WASManagedRuntime.this._extendedTransaction, null);
            }
            catch (Exception e) {
                throw new InvalidStateException(_loc.get("was-reflection-exception")).setCause(e);
            }
        }

        @Override
        public void begin() throws NotSupportedException, SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "begin"));
        }

        @Override
        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "commit"));
        }

        @Override
        public void resume(Transaction arg0) throws IllegalStateException, InvalidTransactionException, SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "resume"));
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            if (WASManagedRuntime.this._log.isTraceEnabled()) {
                WASManagedRuntime.this._log.trace(_loc.get("was-unsupported-op", "rollback"));
            }
        }

        @Override
        public void setRollbackOnly() throws IllegalStateException, SystemException {
            if (WASManagedRuntime.this._log.isTraceEnabled()) {
                WASManagedRuntime.this._log.trace(_loc.get("was-unsupported-op", "setRollbackOnly"));
            }
        }

        @Override
        public void setTransactionTimeout(int arg0) throws SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "setTransactionTimeout"));
        }

        @Override
        public Transaction suspend() throws SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "suspend"));
        }

        @Override
        public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "delistResource"));
        }

        @Override
        public boolean enlistResource(XAResource arg0) throws IllegalStateException, RollbackException, SystemException {
            throw new InvalidStateException(_loc.get("was-unsupported-op", "enlistResource"));
        }
    }
}

