/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.instrumentation.InstrumentationManager;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.instrumentation.InstrumentationProvider;

public class InstrumentationManagerImpl
implements InstrumentationManager {
    public Set<InstrumentationProvider> _providers = Collections.synchronizedSet(new HashSet());
    private boolean _closed = false;

    @Override
    public void initialize(OpenJPAConfiguration conf, PluginListValue pluginVal) {
        InstrumentationProvider[] providers = (InstrumentationProvider[])pluginVal.instantiate(InstrumentationProvider.class, conf);
        this._providers.addAll(Arrays.asList(providers));
    }

    @Override
    public void manageProvider(InstrumentationProvider provider) {
        this._providers.add(provider);
    }

    @Override
    public Set<InstrumentationProvider> getProviders() {
        return Collections.unmodifiableSet(this._providers);
    }

    @Override
    public void start(InstrumentationLevel level, Object context) {
        if (this._providers == null || this._providers.size() == 0) {
            return;
        }
        for (InstrumentationProvider provider : this._providers) {
            if (!provider.isStarted()) {
                provider.start();
            }
            provider.startInstruments(level, context);
        }
    }

    @Override
    public void stop(InstrumentationLevel level, Object context) {
        if (this._providers == null || this._providers.size() == 0) {
            return;
        }
        for (InstrumentationProvider provider : this._providers) {
            provider.stopInstruments(level, context);
        }
    }

    @Override
    public void close() throws Exception {
        if (this._closed) {
            return;
        }
        for (InstrumentationProvider provider : this._providers) {
            provider.stop();
        }
        this._closed = true;
    }
}

