/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.Payload;
import jakarta.validation.ReportAsSingleViolation;
import jakarta.validation.ValidationException;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.Scope;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import jakarta.validation.valueextraction.Unwrapping;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.util.AnnotationsManager;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

public class ConstraintD<A extends Annotation>
implements ConstraintDescriptor<A> {
    private final A annotation;
    private final Scope scope;
    private final Meta<?> meta;
    private final Set<Class<? extends Payload>> payload;
    private final Set<Class<?>> groups;
    private final boolean reportAsSingle;
    private final ValidateUnwrappedValue valueUnwrapping;
    private final Map<String, Object> attributes;
    private final ConstraintTarget validationAppliesTo;
    private final Set<ConstraintDescriptor<?>> composingConstraints;
    private final List<Class<? extends ConstraintValidator<A, ?>>> constraintValidatorClasses;
    private final Lazy<String> toString = new Lazy<String>(() -> String.format("%s: %s", ConstraintD.class.getSimpleName(), this.getAnnotation()));

    private static <T> Set<T> set(Supplier<T[]> array) {
        return Stream.of(array.get()).collect(ToUnmodifiable.set());
    }

    public ConstraintD(A annotation, Scope scope, Meta<?> meta, ApacheValidatorFactory validatorFactory) {
        this.annotation = (Annotation)Validate.notNull(annotation, "annotation", new Object[0]);
        this.scope = Validate.notNull(scope, "scope", new Object[0]);
        this.meta = Validate.notNull(meta, "meta", new Object[0]);
        this.payload = this.computePayload();
        this.groups = ConstraintD.set(() -> (Class[])this.read(ConstraintAnnotationAttributes.GROUPS, Optionality.REQUIRED));
        this.reportAsSingle = annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.valueUnwrapping = this.computeValidateUnwrappedValue();
        this.attributes = AnnotationsManager.readAttributes(annotation);
        this.validationAppliesTo = this.computeValidationAppliesTo(meta.getElementType());
        Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
        this.composingConstraints = this.computeComposingConstraints(validatorFactory);
        this.constraintValidatorClasses = this.computeConstraintValidatorClasses(validatorFactory);
    }

    @Override
    public A getAnnotation() {
        return this.annotation;
    }

    @Override
    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    @Override
    public List<Class<? extends ConstraintValidator<A, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorClasses;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.reportAsSingle;
    }

    @Override
    public String getMessageTemplate() {
        return (String)this.read(ConstraintAnnotationAttributes.MESSAGE, Optionality.REQUIRED);
    }

    @Override
    public ConstraintTarget getValidationAppliesTo() {
        return this.validationAppliesTo;
    }

    @Override
    public ValidateUnwrappedValue getValueUnwrapping() {
        return this.valueUnwrapping;
    }

    @Override
    public <U> U unwrap(Class<U> type) throws ValidationException {
        try {
            return type.cast(this);
        }
        catch (ClassCastException e) {
            throw new ValidationException(e);
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public Class<?> getDeclaringClass() {
        return this.meta.getDeclaringClass();
    }

    public ElementType getDeclaredOn() {
        return this.meta.getElementType();
    }

    public String toString() {
        return this.toString.get();
    }

    private <T> T read(ConstraintAnnotationAttributes attr) {
        return this.read(attr, Optionality.OPTIONAL);
    }

    private <T> T read(ConstraintAnnotationAttributes attr, Optionality optionality) {
        Class<? extends Annotation> constraintType = this.annotation.annotationType();
        Optional<Object> result = Optional.of(constraintType).map(attr::analyze).filter(ConstraintAnnotationAttributes.Worker::isValid).map(w -> w.read((Annotation)this.annotation));
        Exceptions.raiseUnless(optionality.isOptional() || result.isPresent(), ConstraintDefinitionException::new, "Required attribute %s missing from constraint type %s", f -> f.args(attr.getAttributeName(), constraintType));
        return result.orElse(null);
    }

    private Set<ConstraintDescriptor<?>> computeComposingConstraints(ApacheValidatorFactory validatorFactory) {
        return Stream.of(validatorFactory.getAnnotationsManager().getComposingConstraints((Annotation)this.annotation)).map(c -> new ConstraintD<Annotation>((Annotation)c, this.scope, this.meta, validatorFactory)).collect(ToUnmodifiable.set());
    }

    private List<Class<? extends ConstraintValidator<A, ?>>> computeConstraintValidatorClasses(ApacheValidatorFactory validatorFactory) {
        return validatorFactory.getConstraintsCache().getConstraintValidatorClasses(this.annotation.annotationType());
    }

    private ValidateUnwrappedValue computeValidateUnwrappedValue() {
        Set<Class<Payload>> p = this.getPayload();
        boolean unwrap = p.contains(Unwrapping.Unwrap.class);
        boolean skip = p.contains(Unwrapping.Skip.class);
        if (unwrap) {
            Validate.validState(!skip, "Cannot specify both %s and %s", Unwrapping.Unwrap.class.getSimpleName(), Unwrapping.Skip.class.getSimpleName());
            return ValidateUnwrappedValue.UNWRAP;
        }
        return skip ? ValidateUnwrappedValue.SKIP : ValidateUnwrappedValue.DEFAULT;
    }

    private Set<Class<? extends Payload>> computePayload() {
        Set<Class<? extends Payload>> result = ConstraintD.set(() -> (Class[])this.read(ConstraintAnnotationAttributes.PAYLOAD, Optionality.REQUIRED));
        if (result.containsAll(Arrays.asList(Unwrapping.Unwrap.class, Unwrapping.Skip.class))) {
            Exceptions.raise(ConstraintDeclarationException::new, "Constraint %s declared at %s specifies conflicting value unwrapping hints", this.annotation, this.meta.getHost());
        }
        return result;
    }

    private ConstraintTarget computeValidationAppliesTo(ElementType elementType) {
        ConstraintTarget result = (ConstraintTarget)((Object)this.read(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO));
        if (result != null && result != ConstraintTarget.IMPLICIT) {
            Object host = this.meta.getHost();
            Exceptions.raiseUnless(host instanceof Executable, ConstraintDeclarationException::new, "Illegal %s on %s", new Object[]{result, host});
            switch (result) {
                case PARAMETERS: {
                    Exceptions.raiseIf(((Executable)host).getParameterCount() == 0, ConstraintDeclarationException::new, "Illegal specification of %s on %s with no parameters", new Object[]{result, elementType});
                    break;
                }
                case RETURN_VALUE: {
                    Exceptions.raiseIf(Void.TYPE.equals(this.meta.getType()), ConstraintDeclarationException::new, "Illegal %s on %s method %s", new Object[]{result, Void.TYPE, host});
                    break;
                }
                default: {
                    Exceptions.raise(IllegalStateException::new, "Unknown %s %s", new Object[]{ConstraintTarget.class.getSimpleName(), result});
                }
            }
        }
        return result;
    }

    private static enum Optionality {
        OPTIONAL,
        REQUIRED;


        public boolean isOptional() {
            return this == OPTIONAL;
        }
    }
}

