/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.DecimalMin;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class DecimalMinValidator<T>
implements ConstraintValidator<DecimalMin, T> {
    private BigDecimal minValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMin annotation) {
        try {
            this.minValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
        this.inclusive = annotation.inclusive();
    }

    protected boolean isValid(BigDecimal value) {
        if (value == null) {
            return true;
        }
        int comparison = value.compareTo(this.minValue);
        return comparison > 0 || this.inclusive && comparison == 0;
    }

    public static class ForNumber
    extends DecimalMinValidator<Number> {
        @Override
        public boolean isValid(Number value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            BigDecimal bigValue = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : new BigDecimal(value.doubleValue()));
            return this.isValid(bigValue);
        }
    }

    public static class ForString
    extends DecimalMinValidator<String> {
        @Override
        public boolean isValid(String value, ConstraintValidatorContext context) {
            return value == null || this.isValid(new BigDecimal(value));
        }
    }
}

