/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dao.server.SOAPLoginDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.IUserManager;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.room.RoomOptionsDTO;
import org.apache.openmeetings.db.dto.user.ExternalUserDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.server.RemoteSessionObject;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.mapper.UserMapper;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.InternalServiceException;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.apache.openmeetings.webservice.schema.UserDTOListWrapper;
import org.apache.openmeetings.webservice.schema.UserDTOWrapper;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.Validatable;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.UserWebService", targetNamespace="http://webservice.openmeetings.apache.org/", portName="UserService")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="UserService")
@Path(value="/user")
public class UserWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(UserWebService.class);
    @Inject
    private IUserManager userManager;
    @Inject
    private SOAPLoginDao soapDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private UserMapper uMapper;

    @WebMethod
    @GET
    @Path(value="/login")
    @Operation(description="Login and create sessionId required for sub-sequent calls", responses={@ApiResponse(responseCode="200", description="ServiceResult with error code or SID and userId", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error of server error")})
    public ServiceResult login(@Parameter(required=true, description="login or email of Openmeetings user with admin or SOAP-rights") @WebParam(name="user") @QueryParam(value="user") String user, @Parameter(required=true, description="password") @WebParam(name="pass") @QueryParam(value="pass") String pass) {
        try {
            log.debug("Login user");
            User u = this.userDao.login(user, pass);
            if (u == null) {
                return new ServiceResult("error.bad.credentials", ServiceResult.Type.ERROR);
            }
            Sessiondata sd = this.sessionDao.create(u.getId(), u.getLanguageId());
            log.debug("Login user: {}", (Object)u.getId());
            return new ServiceResult(sd.getSessionId(), ServiceResult.Type.SUCCESS);
        }
        catch (OmException oe) {
            return oe.getKey() == null ? ServiceResult.UNKNOWN : new ServiceResult(oe.getKey(), ServiceResult.Type.ERROR);
        }
        catch (Exception err) {
            log.error("[login]", (Throwable)err);
            return ServiceResult.UNKNOWN;
        }
    }

    @WebMethod
    @GET
    @Path(value="/")
    @Operation(description="Lists all users in the system!", responses={@ApiResponse(responseCode="200", description="list of users", content={@Content(schema=@Schema(implementation=UserDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<UserDTO> get(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> UserDTO.list((List)this.userDao.getAllUsers()));
    }

    @WebMethod
    @POST
    @Path(value="/")
    @Operation(description="Adds a new User like through the Frontend, but also does activates the\n Account To do SSO see the methods to create a hash and use those ones!", responses={@ApiResponse(responseCode="200", description="list of users", content={@Content(schema=@Schema(implementation=UserDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public UserDTO add(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="user object") @WebParam(name="user") @FormParam(value="user") UserDTO user, @Parameter(required=true, description="whatever or not to send email, leave empty for auto-send") @WebParam(name="confirm") @FormParam(value="confirm") Boolean confirm) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Object ouser;
            if (!OpenmeetingsVariables.isAllowRegisterSoap()) {
                throw new InternalServiceException("Soap register is denied in Settings");
            }
            User testUser = this.userDao.getExternalUser(user.getExternalId(), user.getExternalType());
            if (testUser != null) {
                throw new InternalServiceException("User does already exist!");
            }
            String tz = user.getTimeZoneId();
            if (Strings.isEmpty((String)tz)) {
                tz = OpenmeetingsVariables.getDefaultTimezone();
            }
            if (user.getAddress() == null) {
                user.setAddress(new Address());
                user.getAddress().setCountry(Locale.getDefault().getCountry());
            }
            if (user.getLanguageId() == null) {
                user.setLanguageId(Long.valueOf(1L));
            }
            User jsonUser = this.uMapper.get(user);
            Validatable passVal = new Validatable((Object)user.getPassword());
            new StrongPasswordValidator(false, jsonUser).validate((IValidatable)passVal);
            if (!passVal.isValid()) {
                StringBuilder sb = new StringBuilder();
                for (IValidationError err : passVal.getErrors()) {
                    sb.append(((ValidationError)err).getMessage()).append(System.lineSeparator());
                }
                log.trace("addNewUser::weak password '*****', msg: {}", (Object)sb);
                throw new InternalServiceException(sb.toString());
            }
            this.checkEmail(user.getAddress().getEmail());
            try {
                jsonUser.addGroup(this.groupDao.get(OpenmeetingsVariables.getDefaultGroup()));
                ouser = this.userManager.registerUser(jsonUser, user.getPassword(), null);
            }
            catch (NoSuchAlgorithmException | OmException e) {
                throw new InternalServiceException("Unexpected error while creating user");
            }
            if (ouser == null) {
                throw new InternalServiceException(ServiceResult.UNKNOWN.getMessage());
            }
            if (ouser instanceof String) {
                String str = (String)ouser;
                throw new InternalServiceException(str);
            }
            User u = (User)ouser;
            u.getRights().add(User.Right.ROOM);
            if (Strings.isEmpty((String)user.getExternalId()) && Strings.isEmpty((String)user.getExternalType())) {
                u.getRights().add(User.Right.LOGIN);
                u.getRights().add(User.Right.DASHBOARD);
            }
            u = this.userDao.update(u, sd.getUserId());
            return new UserDTO(u);
        });
    }

    private void checkEmail(String email) {
        Validatable emailVal = new Validatable((Object)email);
        RfcCompliantEmailAddressValidator.getInstance().validate((IValidatable)emailVal);
        if (!emailVal.isValid()) {
            throw new InternalServiceException(LabelDao.getString((String)"234", (long)1L));
        }
    }

    @WebMethod
    @DELETE
    @Path(value="/{id}")
    @Operation(description="Delete a certain user by its id", responses={@ApiResponse(responseCode="200", description="id of the user deleted, error code otherwise", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the openmeetings user id") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.ADMIN, (Sessiondata sd) -> {
            this.userDao.delete((User)this.userDao.get(id), sd.getUserId());
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @DELETE
    @Path(value="/{externaltype}/{externalid}")
    @Operation(description="Delete a certain user by its external user id", responses={@ApiResponse(responseCode="200", description="id of user deleted, or error code", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult deleteExternal(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="externalUserId") @WebParam(name="externaltype") @PathParam(value="externaltype") String externalType, @Parameter(required=true, description="externalType") @WebParam(name="externalid") @PathParam(value="externalid") String externalId) throws ServiceException {
        return this.performCall(sid, User.Right.ADMIN, (Sessiondata sd) -> {
            User user = this.userDao.getExternalUser(externalId, externalType);
            this.userDao.delete(user, sd.getUserId());
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @POST
    @Path(value="/hash")
    @Operation(description="Sets the SessionObject for a certain SID, after setting this\n Session-Object you can use the SID + a RoomId to enter any Room. ...\n  Session-Hashs are deleted 15 minutes after the creation if not used.", responses={@ApiResponse(responseCode="200", description="secure hash or error code", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult getRoomHash(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="user details to set") @WebParam(name="user") @FormParam(value="user") ExternalUserDTO user, @Parameter(required=true, description="room options to set") @WebParam(name="options") @FormParam(value="options") RoomOptionsDTO options) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            if (Strings.isEmpty((String)user.getExternalId()) || Strings.isEmpty((String)user.getExternalType())) {
                return new ServiceResult("externalId and/or externalType are not set", ServiceResult.Type.ERROR);
            }
            RemoteSessionObject remoteSessionObject = new RemoteSessionObject(user);
            log.debug(remoteSessionObject.toString());
            String xmlString = remoteSessionObject.toString();
            log.trace("jsonString {}", (Object)xmlString);
            String hash = this.soapDao.addSOAPLogin(sid, options);
            if (hash != null) {
                if (options.isAllowSameURLMultipleTimes()) {
                    sd.setPermanent(true);
                }
                sd.setXml(xmlString);
                sd = this.sessionDao.update(sd);
                return new ServiceResult(hash, ServiceResult.Type.SUCCESS);
            }
            return ServiceResult.UNKNOWN;
        });
    }
}

