/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.menu;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryAbstractBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.widget.menu.IMenuItem;
import org.wicketstuff.jquery.ui.widget.menu.Menu;

public class ContextMenu
extends Menu {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXTMENU_CSS_CLASS = "context-menu";

    public ContextMenu(String id) {
        super(id);
    }

    public ContextMenu(String id, List<IMenuItem> items) {
        super(id, items);
    }

    public ContextMenu(String id, Options options) {
        super(id, options);
    }

    public ContextMenu(String id, List<IMenuItem> items, Options options) {
        super(id, items, options);
    }

    protected String getPositionOption(Component component) {
        return String.format("{ my: 'left top', collision: 'none', of: jQuery('%s') }", IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.newContextMenuDocumentBehavior()});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.append("class", (CharSequence)CONTEXTMENU_CSS_CLASS, " ");
        tag.append("style", (CharSequence)"position: absolute; display: none;", ";");
    }

    void fireOnContextMenu(AjaxRequestTarget target, Component component) {
        this.onContextMenu(target, component);
        target.add(new Component[]{this});
        target.appendJavaScript((CharSequence)String.format("jQuery('%s').show().position(%s);", IJQueryWidget.JQueryWidget.getSelector((Component)this), this.getPositionOption(component)));
    }

    protected void onContextMenu(AjaxRequestTarget target, Component component) {
    }

    protected JQueryAbstractBehavior newContextMenuDocumentBehavior() {
        return new JQueryAbstractBehavior(){
            private static final long serialVersionUID = 1L;

            protected String $() {
                StringBuilder builder = new StringBuilder();
                String selector = IJQueryWidget.JQueryWidget.getSelector((Component)ContextMenu.this);
                builder.append("jQuery(document).click(function(e) { if (e.which == 1) { jQuery('").append(selector).append("').hide(); } } );\n");
                builder.append("jQuery(document).keyup(function(e) { if (e.which == 27) { jQuery('").append(selector).append("').hide(); } });\n");
                return builder.toString();
            }
        };
    }
}

