/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.impl.execution.SpecialBroadcastItem;
import com.hazelcast.jet.impl.util.Util;
import java.util.Objects;

public final class Watermark
implements SpecialBroadcastItem {
    private final long timestamp;
    private final byte key;

    public Watermark(long timestamp) {
        this.timestamp = timestamp;
        this.key = 0;
    }

    public Watermark(long timestamp, byte key) {
        this.timestamp = timestamp;
        this.key = key;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public byte key() {
        return this.key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Watermark)) return false;
        Watermark waterMark = (Watermark)o;
        if (this.timestamp != waterMark.timestamp) return false;
        if (this.key != waterMark.key) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.key);
    }

    public String toString() {
        return this.timestamp == Long.MAX_VALUE ? "Watermark{IDLE_MESSAGE}" : "Watermark{ts=" + Util.toLocalTime(this.timestamp) + ", key=" + this.key + "}";
    }
}

