/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.users;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.ColorBehavior;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.users.PasswordDialog;
import org.apache.openmeetings.web.admin.users.UserForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableGroupAdminDataProvider;
import org.apache.openmeetings.web.room.IconTextModal;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

@AuthorizeInstantiation(value={"ADMIN", "GROUP_ADMIN"})
public class UsersPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
    private final PasswordDialog adminPass = new PasswordDialog("adminPass");
    private UserForm form;
    @Inject
    private UserDao userDao;

    public UsersPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        SearchableDataView<User> dataView = new SearchableDataView<User>("userList", new SearchableGroupAdminDataProvider(UserDao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<User> item) {
                User u = (User)item.getModelObject();
                Long userId = u.getId();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("login")});
                item.add(new Component[]{new Label("firstname")});
                item.add(new Component[]{new Label("lastname")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    UsersPanel.this.form.setModelObject(UsersPanel.this.userDao.get(userId));
                    UsersPanel.this.form.setNewRecordVisible(false);
                    UsersPanel.this.form.update((AjaxRequestTarget)target);
                })});
                StringBuilder cl = UsersPanel.this.getRowClass(u.getId(), ((User)UsersPanel.this.form.getModelObject()).getId());
                if (u.isDeleted()) {
                    cl.append(" deleted");
                }
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)cl)});
            }
        };
        this.add(new Component[]{this.listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{UsersPanel.this.listContainer});
            }
        };
        DataViewContainer<User> container = new DataViewContainer<User>(this.listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<User>("orderById", "id", container)).addLink(new OmOrderByBorder<User>("orderByLogin", "login", container)).addLink(new OmOrderByBorder<User>("orderByFirstName", "firstname", container)).addLink(new OmOrderByBorder<User>("orderByLastName", "lastname", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator, this.adminPass});
        Modal warning = new IconTextModal("warning").withLabel((IModel<String>)new ResourceModel("warn.nogroup")).withErrorIcon(ColorBehavior.Color.Warning).header((IModel)new ResourceModel("797")).addButton((Component)OmModalCloseButton.of("54"));
        this.form = new UserForm("form", this.listContainer, UserDao.getNewUserInstance((User)this.userDao.get(WebSession.getUserId())), this.adminPass, (Modal<String>)warning);
        this.add(new Component[]{this.form, warning});
        super.onInitialize();
    }
}

