/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlCriticality
extends GrammarAction<ControlsContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlCriticality.class);

    public StoreControlCriticality() {
        super("Store the control criticality");
    }

    @Override
    public void action(ControlsContainer container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Control control = container.getCurrentControl();
        BerValue value = tlv.getValue();
        try {
            control.setCritical(BooleanDecoder.parse(value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err(I18n.ERR_08103_BAD_CONTROL_CRITICALITY, Strings.dumpBytes(value.getData()), bde.getMessage()));
            throw new DecoderException(bde.getMessage(), bde);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_08202_CONTROL_CRITICALITY, control.isCritical()));
        }
    }
}

