/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import com.github.openjson.JSONException;
import com.github.openjson.JSONStringer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.AjaxSettings;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.JQuery;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2Behavior;
import org.wicketstuff.select2.Settings;

public abstract class AbstractSelect2Choice<T, M>
extends FormComponent<M>
implements IRequestListener {
    private static final long serialVersionUID = 1L;
    private final Select2Behavior select2Behavior = new Select2Behavior();
    private ChoiceProvider<T> provider;
    private boolean convertInputPerformed = false;

    public AbstractSelect2Choice(String id) {
        this(id, null, null);
    }

    public AbstractSelect2Choice(String id, IModel<M> model) {
        this(id, model, null);
    }

    public AbstractSelect2Choice(String id, ChoiceProvider<T> provider) {
        this(id, null, provider);
    }

    public AbstractSelect2Choice(String id, IModel<M> model, ChoiceProvider<T> provider) {
        super(id, model);
        this.provider = provider;
        this.add(new Behavior[]{this.select2Behavior});
        this.setOutputMarkupId(true);
    }

    public final Settings getSettings() {
        return this.select2Behavior.getSettings();
    }

    public final void setProvider(ChoiceProvider<T> provider) {
        this.provider = provider;
    }

    public final ChoiceProvider<T> getProvider() {
        if (this.provider == null) {
            throw new IllegalStateException("Select2 choice component: " + this.getId() + " does not have a ChoiceProvider set");
        }
        return this.provider;
    }

    public final void convertInput() {
        String[] inputAsArray = this.getInputAsArray();
        Object convertedInput = this.convertValue(inputAsArray);
        this.setConvertedInput(convertedInput);
        this.convertInputPerformed = true;
    }

    protected final Collection<T> convertIdsToChoices(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getProvider().toChoices(ids);
    }

    protected String getJquerySafeMarkupId() {
        return this.getMarkupId().replace(".", "\\\\.");
    }

    protected String getEscapedJsString(String key) {
        String value = this.getString(key);
        return Strings.replaceAll((CharSequence)value, (CharSequence)"'", (CharSequence)"\\'").toString();
    }

    protected final M getCurrentValue() {
        if (this.hasRawInput()) {
            if (this.convertInputPerformed) {
                return (M)this.getConvertedInput();
            }
            String raw = this.getRawInput();
            Object result = null;
            if (raw != null) {
                String[] values = raw.split(";");
                result = this.convertValue(values);
            }
            return (M)result;
        }
        return (M)this.getModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.isAjax() && !this.getSettings().isStateless()) {
            AjaxSettings ajax = this.getSettings().getAjax(true);
            ajax.setData(String.format("function(params) { return { '%s': params.term, page: params.page, '%s':true, '%s':[window.location.protocol, '//', window.location.host, window.location.pathname].join('')}; }", this.getSettings().getQueryParam(), "wicket-ajax", "wicket-ajax-baseurl"));
            ajax.setProcessResults("function(data, page) { return { results: data.items, pagination: { more: data.more } };  }");
        } else if (this.getSettings().isStateless()) {
            AjaxSettings ajax = this.getSettings().getAjax(true);
            ajax.setProcessResults("function(data, page) { return { results: data.items, pagination: { more: data.more } };  }");
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.getSettings().isStateless()) {
            if (Strings.isEmpty((String)this.getSettings().getMountPath())) {
                throw new IllegalStateException("Select2 in stateless mode should specify a mountPath");
            }
            this.getSettings().getAjax(true).setUrl(this.getSettings().getMountPath());
        } else if (this.isAjax()) {
            this.getSettings().getAjax(true).setUrl(this.urlForListener(null));
        }
    }

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target;
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxRequestTarget && (target = (AjaxRequestTarget)event.getPayload()).getComponents().contains((Object)this)) {
            target.prependJavaScript((CharSequence)JQuery.execute("$('#%s').select2('destroy');", this.getJquerySafeMarkupId()));
        }
    }

    protected boolean getStatelessHint() {
        if (this.getSettings().isStateless()) {
            return true;
        }
        return !this.isAjax();
    }

    public boolean isAjax() {
        return this.provider != null;
    }

    public static <T> void generateJSON(ChoiceProvider<T> provider, OutputStream outputStream) {
        AbstractSelect2Choice.generateJSON("q", provider, outputStream);
    }

    public static <T> void generateJSON(String queryParam, ChoiceProvider<T> provider, OutputStream outputStream) {
        Request request = RequestCycle.get().getRequest();
        IRequestParameters params = request.getRequestParameters();
        String term = params.getParameterValue(queryParam).toOptionalString();
        int page = params.getParameterValue("page").toInt(1);
        Response response = new Response();
        provider.query(term, --page, response);
        OutputStreamWriter out = new OutputStreamWriter(outputStream, request.getCharset());
        JSONStringer json = new JSONStringer();
        try {
            json.object();
            json.key("items").array();
            for (Object item : response) {
                json.object();
                provider.toJson(item, json);
                json.endObject();
            }
            json.endArray();
            json.key("more").value((Object)response.getHasMore()).endObject();
            out.write(json.toString());
        }
        catch (JSONException | IOException e) {
            throw new RuntimeException("Could not write Json response", e);
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Json to servlet response", e);
        }
        try {
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Json to servlet response", e);
        }
    }

    public void onRequest() {
        WebResponse webResponse = (WebResponse)this.getRequestCycle().getResponse();
        webResponse.setContentType("application/json");
        AbstractSelect2Choice.generateJSON(this.getSettings().getQueryParam(), this.provider, webResponse.getOutputStream());
    }

    protected void onDetach() {
        this.convertInputPerformed = false;
        if (this.isAjax()) {
            this.getProvider().detach();
        }
        super.onDetach();
    }

    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice) {
        buffer.append("<option selected=\"selected\" value=\"").append((Object)Strings.escapeMarkup((CharSequence)this.getProvider().getIdValue(choice))).append("\">").append((Object)Strings.escapeMarkup((CharSequence)this.getProvider().getDisplayValue(choice))).append("</option>");
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        super.onComponentTag(tag);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.provider == null) {
            super.onComponentTagBody(markupStream, openTag);
        } else {
            M currentValue = this.getCurrentValue();
            this.replaceComponentTagBody(markupStream, openTag, this.createOptionsHtml(currentValue));
        }
    }

    protected abstract CharSequence createOptionsHtml(M var1);

    public boolean isInputNullable() {
        return true;
    }
}

