/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.calendar;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.JQueryContainer;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.calendar.CalendarBehavior;
import org.wicketstuff.jquery.ui.calendar.CalendarModel;
import org.wicketstuff.jquery.ui.calendar.CalendarModelBehavior;
import org.wicketstuff.jquery.ui.calendar.EventSource;
import org.wicketstuff.jquery.ui.calendar.ICalendarListener;

public class Calendar
extends JQueryContainer
implements ICalendarListener {
    private static final long serialVersionUID = 1L;
    private List<EventSource> sources;
    private CalendarModelBehavior modelBehavior;
    protected final Options options;

    public Calendar(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public Calendar(String id, CalendarModel model) {
        this(id, model, new Options());
    }

    public Calendar(String id, CalendarModel model, Options options) {
        super(id, (IModel)model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public CalendarModel getModel() {
        return (CalendarModel)this.getDefaultModel();
    }

    public void addSource(EventSource source) {
        if (this.sources == null) {
            this.sources = Generics.newArrayList();
        }
        this.sources.add(source);
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('%s').fullCalendar('refetchEvents');", IJQueryWidget.JQueryWidget.getSelector((Component)this)));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newCalendarModelBehavior(this.getModel());
        this.add(new Behavior[]{this.modelBehavior});
    }

    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        StringBuilder sourceBuilder = new StringBuilder();
        sourceBuilder.append(String.format("{ url: '%s' }", this.modelBehavior.getCallbackUrl()));
        if (this.sources != null) {
            for (EventSource source : this.sources) {
                sourceBuilder.append(", ");
                sourceBuilder.append(source.toString());
            }
        }
        behavior.setOption("eventSources", (Object)String.format("[%s]", sourceBuilder.toString()));
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new CalendarBehavior(selector, this.options, this);
    }

    protected CalendarModelBehavior newCalendarModelBehavior(CalendarModel model) {
        return new CalendarModelBehavior(model);
    }
}

