/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.util.Nonbinding;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansConstants;

public final class AnnotationUtil {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Set<Annotation> DEFAULT_AND_ANY_ANNOTATION = Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(new Annotation[]{DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE})));

    private AnnotationUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isDeclaringClass(Class<?> declaringClass, Annotation declaredAnnotation) {
        for (Annotation annotation : declaringClass.getDeclaredAnnotations()) {
            if (!annotation.equals(declaredAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getDeclaringClass(Annotation declaredAnnotation, Class<?> typeHierarchy) {
        if (typeHierarchy == null) {
            return null;
        }
        if (AnnotationUtil.isDeclaringClass(typeHierarchy, declaredAnnotation)) {
            return typeHierarchy;
        }
        return AnnotationUtil.getDeclaringClass(declaredAnnotation, typeHierarchy.getSuperclass());
    }

    public static boolean hasMethodAnnotation(Method method, Class<? extends Annotation> clazz) {
        Annotation[] anns;
        Method element = method;
        for (Annotation annotation : anns = AnnotationUtil.getDeclaredAnnotations(element)) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        try {
            return element.getDeclaredAnnotations();
        }
        catch (LinkageError e) {
            return element.getDeclaredAnnotations();
        }
    }

    public static <X> boolean hasAnnotatedMethodParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    public static <X> boolean hasAnnotatedMethodMultipleParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        boolean found = false;
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public static <X> Type getAnnotatedMethodFirstParameterWithAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return parameter.getBaseType();
        }
        return null;
    }

    public static Type getTypeOfParameterWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type result = null;
        int index = 0;
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                found = true;
                break;
            }
            if (found) {
                result = method.getGenericParameterTypes()[index];
                break;
            }
            ++index;
        }
        return result;
    }

    public static <X, T extends Annotation> T getAnnotatedMethodFirstParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<T> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return (T)((Annotation)clazz.cast(parameter.getAnnotation(clazz)));
        }
        return null;
    }

    public static boolean isCdiAnnotationEqual(Annotation annotation1, Annotation annotation2) {
        Asserts.assertNotNull(annotation1, "annotation1 argument can not be null");
        Asserts.assertNotNull(annotation2, "annotation2 argument can not be null");
        Class<? extends Annotation> qualifier1AnnotationType = annotation1.annotationType();
        if (qualifier1AnnotationType == null || !qualifier1AnnotationType.equals(annotation2.annotationType())) {
            return false;
        }
        List<Method> bindingCdiAnnotationMethods = AnnotationUtil.getBindingCdiAnnotationMethods(qualifier1AnnotationType);
        for (Method method : bindingCdiAnnotationMethods) {
            Object value2;
            Object value1 = AnnotationUtil.callMethod(annotation1, method);
            if (AnnotationUtil.checkEquality(value1, value2 = AnnotationUtil.callMethod(annotation2, method))) continue;
            return false;
        }
        return true;
    }

    public static int getCdiAnnotationHashCode(Annotation annotation) {
        Asserts.assertNotNull(annotation, "annotation argument can not be null");
        int hashCode = 0;
        Class<? extends Annotation> qualifierAnnotationType = annotation.annotationType();
        if (qualifierAnnotationType != null) {
            hashCode = qualifierAnnotationType.hashCode();
        }
        List<Method> bindingCdiAnnotationMethods = AnnotationUtil.getBindingCdiAnnotationMethods(qualifierAnnotationType);
        for (Method method : bindingCdiAnnotationMethods) {
            Object value = AnnotationUtil.callMethod(annotation, method);
            if (value == null) continue;
            hashCode ^= value.hashCode();
        }
        return hashCode;
    }

    private static boolean checkEquality(Object value1, Object value2) {
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null) {
            return true;
        }
        Class<?> valueClass = value1.getClass();
        if (!valueClass.equals(value2.getClass())) {
            return false;
        }
        if (valueClass.isPrimitive()) {
            return value1 == value2;
        }
        if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            if (arrayType.isPrimitive()) {
                if (Long.TYPE == arrayType) {
                    return Arrays.equals((long[])value1, (long[])value2);
                }
                if (Integer.TYPE == arrayType) {
                    return Arrays.equals((int[])value1, (int[])value2);
                }
                if (Short.TYPE == arrayType) {
                    return Arrays.equals((short[])value1, (short[])value2);
                }
                if (Double.TYPE == arrayType) {
                    return Arrays.equals((double[])value1, (double[])value2);
                }
                if (Float.TYPE == arrayType) {
                    return Arrays.equals((float[])value1, (float[])value2);
                }
                if (Boolean.TYPE == arrayType) {
                    return Arrays.equals((boolean[])value1, (boolean[])value2);
                }
                if (Byte.TYPE == arrayType) {
                    return Arrays.equals((byte[])value1, (byte[])value2);
                }
                if (Character.TYPE == arrayType) {
                    return Arrays.equals((char[])value1, (char[])value2);
                }
                return false;
            }
            return Arrays.equals((Object[])value1, (Object[])value2);
        }
        return value1.equals(value2);
    }

    private static Object callMethod(Object instance, Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new WebBeansException("Exception in method call : " + method.getName(), e);
        }
    }

    private static List<Method> getBindingCdiAnnotationMethods(Class<? extends Annotation> qualifierAnnotationType) {
        Method[] qualifierMethods = qualifierAnnotationType.getDeclaredMethods();
        if (qualifierMethods.length > 0) {
            ArrayList<Method> bindingMethods = new ArrayList<Method>();
            for (Method qualifierMethod : qualifierMethods) {
                Annotation[] qualifierMethodAnnotations = AnnotationUtil.getDeclaredAnnotations(qualifierMethod);
                if (qualifierMethodAnnotations.length > 0) {
                    boolean nonbinding = false;
                    for (Annotation qualifierMethodAnnotation : qualifierMethodAnnotations) {
                        if (!Nonbinding.class.equals(qualifierMethodAnnotation.annotationType())) continue;
                        nonbinding = true;
                        break;
                    }
                    if (nonbinding) continue;
                    bindingMethods.add(qualifierMethod);
                    continue;
                }
                bindingMethods.add(qualifierMethod);
            }
            return bindingMethods;
        }
        return Collections.emptyList();
    }

    public static boolean hasClassAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        try {
            Annotation a = clazz.getAnnotation(annotation);
            if (a != null) {
                return true;
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasMetaAnnotation(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Annotation[] anns, Class<? extends Annotation> annotation) {
        return AnnotationUtil.getAnnotation(anns, annotation) != null;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] anns, Class<T> annotation) {
        Asserts.assertNotNull(anns, "anns argument can not be null");
        Asserts.assertNotNull(annotation, "annotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().equals(annotation)) continue;
            return (T)annot;
        }
        return null;
    }

    public static Annotation[] getMetaAnnotations(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            annots.add(annot);
        }
        Annotation[] result = new Annotation[annots.size()];
        result = annots.toArray(result);
        return result;
    }

    public static <T extends Annotation> T getAnnotation(Set<Annotation> annotations, Class<T> annotationClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation ann : annotations) {
            if (!ann.annotationType().equals(annotationClass)) continue;
            return (T)ann;
        }
        return null;
    }

    public static Annotation hasOwbInjectableResource(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            for (String name : WebBeansConstants.OWB_INJECTABLE_RESOURCE_ANNOTATIONS) {
                if (!anno.annotationType().getName().equals(name)) continue;
                return anno;
            }
        }
        return null;
    }

    public static Annotation[] asArray(Set<Annotation> set) {
        if (set != null) {
            Annotation[] anns = new Annotation[set.size()];
            anns = set.toArray(anns);
            return anns;
        }
        return EMPTY_ANNOTATION_ARRAY;
    }
}

