/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf12;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.NonexistentConversationException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.jsf12.JSFUtil;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class WebBeansPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansPhaseListener.class);
    private Boolean owbApplication = null;

    public void afterPhase(PhaseEvent phaseEvent) {
        if (!this.isOwbApplication()) {
            return;
        }
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE) || phaseEvent.getFacesContext().getResponseComplete()) {
            WebBeansContext webBeansContext = WebBeansContext.getInstance();
            ConversationManager conversationManager = webBeansContext.getConversationManager();
            Conversation conversation = conversationManager.getConversationBeanReference();
            ContextFactory contextFactory = webBeansContext.getContextFactory();
            if (conversation.isTransient()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Destroying the conversation context with cid : [{0}]", conversation.getId());
                }
                contextFactory.destroyConversationContext();
            } else {
                ConversationImpl owbConversation = (ConversationImpl)conversation;
                owbConversation.updateTimeOut();
                owbConversation.setInUsed(false);
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (!this.isOwbApplication()) {
            return;
        }
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            WebBeansContext webBeansContext = WebBeansContext.getInstance();
            ConversationManager conversationManager = webBeansContext.getConversationManager();
            Conversation conversation = conversationManager.getConversationBeanReference();
            String cid = JSFUtil.getConversationId();
            ContextFactory contextFactory = webBeansContext.getContextFactory();
            if (conversation.isTransient()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating a new transitional conversation with cid : [{0}]", conversation.getId());
                }
                contextFactory.initConversationContext(null);
                if (cid != null && !cid.equals("")) {
                    throw new NonexistentConversationException("Propogated conversation with cid=" + cid + " is not restored. It creates a new transient conversation.");
                }
            } else {
                ConversationImpl owbConversation;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Restoring conversation with cid : [{0}]", conversation.getId());
                }
                if (!(owbConversation = (ConversationImpl)conversation).getInUsed().compareAndSet(false, true)) {
                    contextFactory.initConversationContext(null);
                    throw new BusyConversationException("Propogated conversation with cid=" + cid + " is used by other request. It creates a new transient conversation");
                }
                ConversationContext conversationContext = conversationManager.getConversationContext(conversation);
                contextFactory.initConversationContext((Object)conversationContext);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private boolean isOwbApplication() {
        if (this.owbApplication == null) {
            this.owbApplication = WebBeansContext.getInstance().getBeanManagerImpl().isInUse();
        }
        return this.owbApplication;
    }
}

