/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequest is the corresponding interface of BACnetConfirmedServiceRequest
type BACnetConfirmedServiceRequest interface {
	BACnetConfirmedServiceRequestContract
	BACnetConfirmedServiceRequestRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetConfirmedServiceRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConfirmedServiceRequest()
	// CreateBuilder creates a BACnetConfirmedServiceRequestBuilder
	CreateBACnetConfirmedServiceRequestBuilder() BACnetConfirmedServiceRequestBuilder
}

// BACnetConfirmedServiceRequestContract provides a set of functions which can be overwritten by a sub struct
type BACnetConfirmedServiceRequestContract interface {
	// GetServiceRequestPayloadLength returns ServiceRequestPayloadLength (virtual field)
	GetServiceRequestPayloadLength() uint32
	// GetServiceRequestLength() returns a parser argument
	GetServiceRequestLength() uint32
	// IsBACnetConfirmedServiceRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConfirmedServiceRequest()
	// CreateBuilder creates a BACnetConfirmedServiceRequestBuilder
	CreateBACnetConfirmedServiceRequestBuilder() BACnetConfirmedServiceRequestBuilder
}

// BACnetConfirmedServiceRequestRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetConfirmedServiceRequestRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetServiceChoice returns ServiceChoice (discriminator field)
	GetServiceChoice() BACnetConfirmedServiceChoice
}

// _BACnetConfirmedServiceRequest is the data-structure of this message
type _BACnetConfirmedServiceRequest struct {
	_SubType interface {
		BACnetConfirmedServiceRequestContract
		BACnetConfirmedServiceRequestRequirements
	}

	// Arguments.
	ServiceRequestLength uint32
}

var _ BACnetConfirmedServiceRequestContract = (*_BACnetConfirmedServiceRequest)(nil)

// NewBACnetConfirmedServiceRequest factory function for _BACnetConfirmedServiceRequest
func NewBACnetConfirmedServiceRequest(serviceRequestLength uint32) *_BACnetConfirmedServiceRequest {
	return &_BACnetConfirmedServiceRequest{ServiceRequestLength: serviceRequestLength}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConfirmedServiceRequestBuilder is a builder for BACnetConfirmedServiceRequest
type BACnetConfirmedServiceRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConfirmedServiceRequestBuilder
	// WithArgServiceRequestLength sets a parser argument
	WithArgServiceRequestLength(uint32) BACnetConfirmedServiceRequestBuilder
	// AsBACnetConfirmedServiceRequestAcknowledgeAlarm converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestAcknowledgeAlarm() BACnetConfirmedServiceRequestAcknowledgeAlarmBuilder
	// AsBACnetConfirmedServiceRequestConfirmedCOVNotification converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestConfirmedCOVNotification() BACnetConfirmedServiceRequestConfirmedCOVNotificationBuilder
	// AsBACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple() BACnetConfirmedServiceRequestConfirmedCOVNotificationMultipleBuilder
	// AsBACnetConfirmedServiceRequestConfirmedEventNotification converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestConfirmedEventNotification() BACnetConfirmedServiceRequestConfirmedEventNotificationBuilder
	// AsBACnetConfirmedServiceRequestGetEnrollmentSummary converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestGetEnrollmentSummary() BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// AsBACnetConfirmedServiceRequestGetEventInformation converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestGetEventInformation() BACnetConfirmedServiceRequestGetEventInformationBuilder
	// AsBACnetConfirmedServiceRequestLifeSafetyOperation converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestLifeSafetyOperation() BACnetConfirmedServiceRequestLifeSafetyOperationBuilder
	// AsBACnetConfirmedServiceRequestSubscribeCOV converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestSubscribeCOV() BACnetConfirmedServiceRequestSubscribeCOVBuilder
	// AsBACnetConfirmedServiceRequestSubscribeCOVProperty converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestSubscribeCOVProperty() BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilder
	// AsBACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple() BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilder
	// AsBACnetConfirmedServiceRequestAtomicReadFile converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestAtomicReadFile() BACnetConfirmedServiceRequestAtomicReadFileBuilder
	// AsBACnetConfirmedServiceRequestAtomicWriteFile converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestAtomicWriteFile() BACnetConfirmedServiceRequestAtomicWriteFileBuilder
	// AsBACnetConfirmedServiceRequestAddListElement converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestAddListElement() BACnetConfirmedServiceRequestAddListElementBuilder
	// AsBACnetConfirmedServiceRequestRemoveListElement converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestRemoveListElement() BACnetConfirmedServiceRequestRemoveListElementBuilder
	// AsBACnetConfirmedServiceRequestCreateObject converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestCreateObject() BACnetConfirmedServiceRequestCreateObjectBuilder
	// AsBACnetConfirmedServiceRequestDeleteObject converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestDeleteObject() BACnetConfirmedServiceRequestDeleteObjectBuilder
	// AsBACnetConfirmedServiceRequestReadProperty converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestReadProperty() BACnetConfirmedServiceRequestReadPropertyBuilder
	// AsBACnetConfirmedServiceRequestReadPropertyMultiple converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestReadPropertyMultiple() BACnetConfirmedServiceRequestReadPropertyMultipleBuilder
	// AsBACnetConfirmedServiceRequestReadRange converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestReadRange() BACnetConfirmedServiceRequestReadRangeBuilder
	// AsBACnetConfirmedServiceRequestWriteProperty converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestWriteProperty() BACnetConfirmedServiceRequestWritePropertyBuilder
	// AsBACnetConfirmedServiceRequestWritePropertyMultiple converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestWritePropertyMultiple() BACnetConfirmedServiceRequestWritePropertyMultipleBuilder
	// AsBACnetConfirmedServiceRequestDeviceCommunicationControl converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestDeviceCommunicationControl() BACnetConfirmedServiceRequestDeviceCommunicationControlBuilder
	// AsBACnetConfirmedServiceRequestConfirmedPrivateTransfer converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestConfirmedPrivateTransfer() BACnetConfirmedServiceRequestConfirmedPrivateTransferBuilder
	// AsBACnetConfirmedServiceRequestConfirmedTextMessage converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestConfirmedTextMessage() BACnetConfirmedServiceRequestConfirmedTextMessageBuilder
	// AsBACnetConfirmedServiceRequestReinitializeDevice converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestReinitializeDevice() BACnetConfirmedServiceRequestReinitializeDeviceBuilder
	// AsBACnetConfirmedServiceRequestVTOpen converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestVTOpen() BACnetConfirmedServiceRequestVTOpenBuilder
	// AsBACnetConfirmedServiceRequestVTClose converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestVTClose() BACnetConfirmedServiceRequestVTCloseBuilder
	// AsBACnetConfirmedServiceRequestVTData converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestVTData() BACnetConfirmedServiceRequestVTDataBuilder
	// AsBACnetConfirmedServiceRequestAuthenticate converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestAuthenticate() BACnetConfirmedServiceRequestAuthenticateBuilder
	// AsBACnetConfirmedServiceRequestRequestKey converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestRequestKey() BACnetConfirmedServiceRequestRequestKeyBuilder
	// AsBACnetConfirmedServiceRequestReadPropertyConditional converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestReadPropertyConditional() BACnetConfirmedServiceRequestReadPropertyConditionalBuilder
	// AsBACnetConfirmedServiceRequestUnknown converts this build to a subType of BACnetConfirmedServiceRequest. It is always possible to return to current builder using Done()
	AsBACnetConfirmedServiceRequestUnknown() BACnetConfirmedServiceRequestUnknownBuilder
	// Build builds the BACnetConfirmedServiceRequest or returns an error if something is wrong
	PartialBuild() (BACnetConfirmedServiceRequestContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetConfirmedServiceRequestContract
	// Build builds the BACnetConfirmedServiceRequest or returns an error if something is wrong
	Build() (BACnetConfirmedServiceRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConfirmedServiceRequest
}

// NewBACnetConfirmedServiceRequestBuilder() creates a BACnetConfirmedServiceRequestBuilder
func NewBACnetConfirmedServiceRequestBuilder() BACnetConfirmedServiceRequestBuilder {
	return &_BACnetConfirmedServiceRequestBuilder{_BACnetConfirmedServiceRequest: new(_BACnetConfirmedServiceRequest)}
}

type _BACnetConfirmedServiceRequestChildBuilder interface {
	utils.Copyable
	setParent(BACnetConfirmedServiceRequestContract)
	buildForBACnetConfirmedServiceRequest() (BACnetConfirmedServiceRequest, error)
}

type _BACnetConfirmedServiceRequestBuilder struct {
	*_BACnetConfirmedServiceRequest

	childBuilder _BACnetConfirmedServiceRequestChildBuilder

	collectedErr []error
}

var _ (BACnetConfirmedServiceRequestBuilder) = (*_BACnetConfirmedServiceRequestBuilder)(nil)

func (b *_BACnetConfirmedServiceRequestBuilder) WithMandatoryFields() BACnetConfirmedServiceRequestBuilder {
	return b
}

func (b *_BACnetConfirmedServiceRequestBuilder) WithArgServiceRequestLength(serviceRequestLength uint32) BACnetConfirmedServiceRequestBuilder {
	b.ServiceRequestLength = serviceRequestLength
	return b
}

func (b *_BACnetConfirmedServiceRequestBuilder) PartialBuild() (BACnetConfirmedServiceRequestContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConfirmedServiceRequest.deepCopy(), nil
}

func (b *_BACnetConfirmedServiceRequestBuilder) PartialMustBuild() BACnetConfirmedServiceRequestContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestAcknowledgeAlarm() BACnetConfirmedServiceRequestAcknowledgeAlarmBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestAcknowledgeAlarmBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestAcknowledgeAlarmBuilder().(*_BACnetConfirmedServiceRequestAcknowledgeAlarmBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestConfirmedCOVNotification() BACnetConfirmedServiceRequestConfirmedCOVNotificationBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestConfirmedCOVNotificationBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestConfirmedCOVNotificationBuilder().(*_BACnetConfirmedServiceRequestConfirmedCOVNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple() BACnetConfirmedServiceRequestConfirmedCOVNotificationMultipleBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestConfirmedCOVNotificationMultipleBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestConfirmedCOVNotificationMultipleBuilder().(*_BACnetConfirmedServiceRequestConfirmedCOVNotificationMultipleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestConfirmedEventNotification() BACnetConfirmedServiceRequestConfirmedEventNotificationBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestConfirmedEventNotificationBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestConfirmedEventNotificationBuilder().(*_BACnetConfirmedServiceRequestConfirmedEventNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestGetEnrollmentSummary() BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder().(*_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestGetEventInformation() BACnetConfirmedServiceRequestGetEventInformationBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestGetEventInformationBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestGetEventInformationBuilder().(*_BACnetConfirmedServiceRequestGetEventInformationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestLifeSafetyOperation() BACnetConfirmedServiceRequestLifeSafetyOperationBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestLifeSafetyOperationBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestLifeSafetyOperationBuilder().(*_BACnetConfirmedServiceRequestLifeSafetyOperationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestSubscribeCOV() BACnetConfirmedServiceRequestSubscribeCOVBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestSubscribeCOVBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestSubscribeCOVBuilder().(*_BACnetConfirmedServiceRequestSubscribeCOVBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestSubscribeCOVProperty() BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestSubscribeCOVPropertyBuilder().(*_BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple() BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilder().(*_BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestAtomicReadFile() BACnetConfirmedServiceRequestAtomicReadFileBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestAtomicReadFileBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestAtomicReadFileBuilder().(*_BACnetConfirmedServiceRequestAtomicReadFileBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestAtomicWriteFile() BACnetConfirmedServiceRequestAtomicWriteFileBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestAtomicWriteFileBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestAtomicWriteFileBuilder().(*_BACnetConfirmedServiceRequestAtomicWriteFileBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestAddListElement() BACnetConfirmedServiceRequestAddListElementBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestAddListElementBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestAddListElementBuilder().(*_BACnetConfirmedServiceRequestAddListElementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestRemoveListElement() BACnetConfirmedServiceRequestRemoveListElementBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestRemoveListElementBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestRemoveListElementBuilder().(*_BACnetConfirmedServiceRequestRemoveListElementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestCreateObject() BACnetConfirmedServiceRequestCreateObjectBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestCreateObjectBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestCreateObjectBuilder().(*_BACnetConfirmedServiceRequestCreateObjectBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestDeleteObject() BACnetConfirmedServiceRequestDeleteObjectBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestDeleteObjectBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestDeleteObjectBuilder().(*_BACnetConfirmedServiceRequestDeleteObjectBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestReadProperty() BACnetConfirmedServiceRequestReadPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestReadPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestReadPropertyBuilder().(*_BACnetConfirmedServiceRequestReadPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestReadPropertyMultiple() BACnetConfirmedServiceRequestReadPropertyMultipleBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestReadPropertyMultipleBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestReadPropertyMultipleBuilder().(*_BACnetConfirmedServiceRequestReadPropertyMultipleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestReadRange() BACnetConfirmedServiceRequestReadRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestReadRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestReadRangeBuilder().(*_BACnetConfirmedServiceRequestReadRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestWriteProperty() BACnetConfirmedServiceRequestWritePropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestWritePropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestWritePropertyBuilder().(*_BACnetConfirmedServiceRequestWritePropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestWritePropertyMultiple() BACnetConfirmedServiceRequestWritePropertyMultipleBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestWritePropertyMultipleBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestWritePropertyMultipleBuilder().(*_BACnetConfirmedServiceRequestWritePropertyMultipleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestDeviceCommunicationControl() BACnetConfirmedServiceRequestDeviceCommunicationControlBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestDeviceCommunicationControlBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestDeviceCommunicationControlBuilder().(*_BACnetConfirmedServiceRequestDeviceCommunicationControlBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestConfirmedPrivateTransfer() BACnetConfirmedServiceRequestConfirmedPrivateTransferBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestConfirmedPrivateTransferBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestConfirmedPrivateTransferBuilder().(*_BACnetConfirmedServiceRequestConfirmedPrivateTransferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestConfirmedTextMessage() BACnetConfirmedServiceRequestConfirmedTextMessageBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestConfirmedTextMessageBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestConfirmedTextMessageBuilder().(*_BACnetConfirmedServiceRequestConfirmedTextMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestReinitializeDevice() BACnetConfirmedServiceRequestReinitializeDeviceBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestReinitializeDeviceBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestReinitializeDeviceBuilder().(*_BACnetConfirmedServiceRequestReinitializeDeviceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestVTOpen() BACnetConfirmedServiceRequestVTOpenBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestVTOpenBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestVTOpenBuilder().(*_BACnetConfirmedServiceRequestVTOpenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestVTClose() BACnetConfirmedServiceRequestVTCloseBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestVTCloseBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestVTCloseBuilder().(*_BACnetConfirmedServiceRequestVTCloseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestVTData() BACnetConfirmedServiceRequestVTDataBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestVTDataBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestVTDataBuilder().(*_BACnetConfirmedServiceRequestVTDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestAuthenticate() BACnetConfirmedServiceRequestAuthenticateBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestAuthenticateBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestAuthenticateBuilder().(*_BACnetConfirmedServiceRequestAuthenticateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestRequestKey() BACnetConfirmedServiceRequestRequestKeyBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestRequestKeyBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestRequestKeyBuilder().(*_BACnetConfirmedServiceRequestRequestKeyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestReadPropertyConditional() BACnetConfirmedServiceRequestReadPropertyConditionalBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestReadPropertyConditionalBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestReadPropertyConditionalBuilder().(*_BACnetConfirmedServiceRequestReadPropertyConditionalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) AsBACnetConfirmedServiceRequestUnknown() BACnetConfirmedServiceRequestUnknownBuilder {
	if cb, ok := b.childBuilder.(BACnetConfirmedServiceRequestUnknownBuilder); ok {
		return cb
	}
	cb := NewBACnetConfirmedServiceRequestUnknownBuilder().(*_BACnetConfirmedServiceRequestUnknownBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConfirmedServiceRequestBuilder) Build() (BACnetConfirmedServiceRequest, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetConfirmedServiceRequest()
}

func (b *_BACnetConfirmedServiceRequestBuilder) MustBuild() BACnetConfirmedServiceRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConfirmedServiceRequestBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConfirmedServiceRequestBuilder().(*_BACnetConfirmedServiceRequestBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetConfirmedServiceRequestChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConfirmedServiceRequestBuilder creates a BACnetConfirmedServiceRequestBuilder
func (b *_BACnetConfirmedServiceRequest) CreateBACnetConfirmedServiceRequestBuilder() BACnetConfirmedServiceRequestBuilder {
	if b == nil {
		return NewBACnetConfirmedServiceRequestBuilder()
	}
	return &_BACnetConfirmedServiceRequestBuilder{_BACnetConfirmedServiceRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetConfirmedServiceRequest) GetServiceRequestPayloadLength() uint32 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint32(utils.InlineIf((bool((m.GetServiceRequestLength()) > (0))), func() any { return uint32((uint32(m.GetServiceRequestLength()) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequest(structType any) BACnetConfirmedServiceRequest {
	if casted, ok := structType.(BACnetConfirmedServiceRequest); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequest); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequest) GetTypeName() string {
	return "BACnetConfirmedServiceRequest"
}

func (m *_BACnetConfirmedServiceRequest) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (serviceChoice)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequest) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetConfirmedServiceRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetConfirmedServiceRequestParse[T BACnetConfirmedServiceRequest](ctx context.Context, theBytes []byte, serviceRequestLength uint32) (T, error) {
	return BACnetConfirmedServiceRequestParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), serviceRequestLength)
}

func BACnetConfirmedServiceRequestParseWithBufferProducer[T BACnetConfirmedServiceRequest](serviceRequestLength uint32) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetConfirmedServiceRequestParseWithBuffer[T](ctx, readBuffer, serviceRequestLength)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetConfirmedServiceRequestParseWithBuffer[T BACnetConfirmedServiceRequest](ctx context.Context, readBuffer utils.ReadBuffer, serviceRequestLength uint32) (T, error) {
	v, err := (&_BACnetConfirmedServiceRequest{ServiceRequestLength: serviceRequestLength}).parse(ctx, readBuffer, serviceRequestLength)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetConfirmedServiceRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, serviceRequestLength uint32) (__bACnetConfirmedServiceRequest BACnetConfirmedServiceRequest, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	serviceChoice, err := ReadDiscriminatorEnumField[BACnetConfirmedServiceChoice](ctx, "serviceChoice", "BACnetConfirmedServiceChoice", ReadEnum(BACnetConfirmedServiceChoiceByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceChoice' field"))
	}

	serviceRequestPayloadLength, err := ReadVirtualField[uint32](ctx, "serviceRequestPayloadLength", (*uint32)(nil), utils.InlineIf((bool((serviceRequestLength) > (0))), func() any { return uint32((uint32(serviceRequestLength) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceRequestPayloadLength' field"))
	}
	_ = serviceRequestPayloadLength

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetConfirmedServiceRequest
	switch {
	case serviceChoice == BACnetConfirmedServiceChoice_ACKNOWLEDGE_ALARM: // BACnetConfirmedServiceRequestAcknowledgeAlarm
		if _child, err = new(_BACnetConfirmedServiceRequestAcknowledgeAlarm).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestAcknowledgeAlarm for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_COV_NOTIFICATION: // BACnetConfirmedServiceRequestConfirmedCOVNotification
		if _child, err = new(_BACnetConfirmedServiceRequestConfirmedCOVNotification).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestConfirmedCOVNotification for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_COV_NOTIFICATION_MULTIPLE: // BACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple
		if _child, err = new(_BACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_EVENT_NOTIFICATION: // BACnetConfirmedServiceRequestConfirmedEventNotification
		if _child, err = new(_BACnetConfirmedServiceRequestConfirmedEventNotification).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestConfirmedEventNotification for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_GET_ENROLLMENT_SUMMARY: // BACnetConfirmedServiceRequestGetEnrollmentSummary
		if _child, err = new(_BACnetConfirmedServiceRequestGetEnrollmentSummary).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestGetEnrollmentSummary for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_GET_EVENT_INFORMATION: // BACnetConfirmedServiceRequestGetEventInformation
		if _child, err = new(_BACnetConfirmedServiceRequestGetEventInformation).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestGetEventInformation for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_LIFE_SAFETY_OPERATION: // BACnetConfirmedServiceRequestLifeSafetyOperation
		if _child, err = new(_BACnetConfirmedServiceRequestLifeSafetyOperation).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestLifeSafetyOperation for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_SUBSCRIBE_COV: // BACnetConfirmedServiceRequestSubscribeCOV
		if _child, err = new(_BACnetConfirmedServiceRequestSubscribeCOV).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestSubscribeCOV for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_SUBSCRIBE_COV_PROPERTY: // BACnetConfirmedServiceRequestSubscribeCOVProperty
		if _child, err = new(_BACnetConfirmedServiceRequestSubscribeCOVProperty).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestSubscribeCOVProperty for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_SUBSCRIBE_COV_PROPERTY_MULTIPLE: // BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple
		if _child, err = new(_BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_READ_FILE: // BACnetConfirmedServiceRequestAtomicReadFile
		if _child, err = new(_BACnetConfirmedServiceRequestAtomicReadFile).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestAtomicReadFile for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_WRITE_FILE: // BACnetConfirmedServiceRequestAtomicWriteFile
		if _child, err = new(_BACnetConfirmedServiceRequestAtomicWriteFile).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestAtomicWriteFile for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_ADD_LIST_ELEMENT: // BACnetConfirmedServiceRequestAddListElement
		if _child, err = new(_BACnetConfirmedServiceRequestAddListElement).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestAddListElement for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_REMOVE_LIST_ELEMENT: // BACnetConfirmedServiceRequestRemoveListElement
		if _child, err = new(_BACnetConfirmedServiceRequestRemoveListElement).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestRemoveListElement for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CREATE_OBJECT: // BACnetConfirmedServiceRequestCreateObject
		if _child, err = new(_BACnetConfirmedServiceRequestCreateObject).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestCreateObject for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_DELETE_OBJECT: // BACnetConfirmedServiceRequestDeleteObject
		if _child, err = new(_BACnetConfirmedServiceRequestDeleteObject).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestDeleteObject for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY: // BACnetConfirmedServiceRequestReadProperty
		if _child, err = new(_BACnetConfirmedServiceRequestReadProperty).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestReadProperty for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_MULTIPLE: // BACnetConfirmedServiceRequestReadPropertyMultiple
		if _child, err = new(_BACnetConfirmedServiceRequestReadPropertyMultiple).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestReadPropertyMultiple for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_RANGE: // BACnetConfirmedServiceRequestReadRange
		if _child, err = new(_BACnetConfirmedServiceRequestReadRange).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestReadRange for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_WRITE_PROPERTY: // BACnetConfirmedServiceRequestWriteProperty
		if _child, err = new(_BACnetConfirmedServiceRequestWriteProperty).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestWriteProperty for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_WRITE_PROPERTY_MULTIPLE: // BACnetConfirmedServiceRequestWritePropertyMultiple
		if _child, err = new(_BACnetConfirmedServiceRequestWritePropertyMultiple).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestWritePropertyMultiple for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_DEVICE_COMMUNICATION_CONTROL: // BACnetConfirmedServiceRequestDeviceCommunicationControl
		if _child, err = new(_BACnetConfirmedServiceRequestDeviceCommunicationControl).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestDeviceCommunicationControl for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_PRIVATE_TRANSFER: // BACnetConfirmedServiceRequestConfirmedPrivateTransfer
		if _child, err = new(_BACnetConfirmedServiceRequestConfirmedPrivateTransfer).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestConfirmedPrivateTransfer for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_TEXT_MESSAGE: // BACnetConfirmedServiceRequestConfirmedTextMessage
		if _child, err = new(_BACnetConfirmedServiceRequestConfirmedTextMessage).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestConfirmedTextMessage for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_REINITIALIZE_DEVICE: // BACnetConfirmedServiceRequestReinitializeDevice
		if _child, err = new(_BACnetConfirmedServiceRequestReinitializeDevice).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestReinitializeDevice for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_VT_OPEN: // BACnetConfirmedServiceRequestVTOpen
		if _child, err = new(_BACnetConfirmedServiceRequestVTOpen).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestVTOpen for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_VT_CLOSE: // BACnetConfirmedServiceRequestVTClose
		if _child, err = new(_BACnetConfirmedServiceRequestVTClose).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestVTClose for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_VT_DATA: // BACnetConfirmedServiceRequestVTData
		if _child, err = new(_BACnetConfirmedServiceRequestVTData).parse(ctx, readBuffer, m, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestVTData for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_AUTHENTICATE: // BACnetConfirmedServiceRequestAuthenticate
		if _child, err = new(_BACnetConfirmedServiceRequestAuthenticate).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestAuthenticate for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_REQUEST_KEY: // BACnetConfirmedServiceRequestRequestKey
		if _child, err = new(_BACnetConfirmedServiceRequestRequestKey).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestRequestKey for type-switch of BACnetConfirmedServiceRequest")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_CONDITIONAL: // BACnetConfirmedServiceRequestReadPropertyConditional
		if _child, err = new(_BACnetConfirmedServiceRequestReadPropertyConditional).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestReadPropertyConditional for type-switch of BACnetConfirmedServiceRequest")
		}
	case 0 == 0: // BACnetConfirmedServiceRequestUnknown
		if _child, err = new(_BACnetConfirmedServiceRequestUnknown).parse(ctx, readBuffer, m, serviceRequestPayloadLength, serviceRequestLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConfirmedServiceRequestUnknown for type-switch of BACnetConfirmedServiceRequest")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [serviceChoice=%v]", serviceChoice)
	}

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequest")
	}

	return _child, nil
}

func (pm *_BACnetConfirmedServiceRequest) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetConfirmedServiceRequest, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequest"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequest")
	}

	if err := WriteDiscriminatorEnumField(ctx, "serviceChoice", "BACnetConfirmedServiceChoice", m.GetServiceChoice(), WriteEnum[BACnetConfirmedServiceChoice, uint8](BACnetConfirmedServiceChoice.GetValue, BACnetConfirmedServiceChoice.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'serviceChoice' field")
	}
	// Virtual field
	serviceRequestPayloadLength := m.GetServiceRequestPayloadLength()
	_ = serviceRequestPayloadLength
	if _serviceRequestPayloadLengthErr := writeBuffer.WriteVirtual(ctx, "serviceRequestPayloadLength", m.GetServiceRequestPayloadLength()); _serviceRequestPayloadLengthErr != nil {
		return errors.Wrap(_serviceRequestPayloadLengthErr, "Error serializing 'serviceRequestPayloadLength' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequest"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequest")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetConfirmedServiceRequest) GetServiceRequestLength() uint32 {
	return m.ServiceRequestLength
}

//
////

func (m *_BACnetConfirmedServiceRequest) IsBACnetConfirmedServiceRequest() {}

func (m *_BACnetConfirmedServiceRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConfirmedServiceRequest) deepCopy() *_BACnetConfirmedServiceRequest {
	if m == nil {
		return nil
	}
	_BACnetConfirmedServiceRequestCopy := &_BACnetConfirmedServiceRequest{
		nil, // will be set by child
		m.ServiceRequestLength,
	}
	return _BACnetConfirmedServiceRequestCopy
}
