/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPulseConverterAdjustValue is the corresponding interface of BACnetConstructedDataPulseConverterAdjustValue
type BACnetConstructedDataPulseConverterAdjustValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAdjustValue returns AdjustValue (property field)
	GetAdjustValue() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataPulseConverterAdjustValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataPulseConverterAdjustValue()
	// CreateBuilder creates a BACnetConstructedDataPulseConverterAdjustValueBuilder
	CreateBACnetConstructedDataPulseConverterAdjustValueBuilder() BACnetConstructedDataPulseConverterAdjustValueBuilder
}

// _BACnetConstructedDataPulseConverterAdjustValue is the data-structure of this message
type _BACnetConstructedDataPulseConverterAdjustValue struct {
	BACnetConstructedDataContract
	AdjustValue BACnetApplicationTagReal
}

var _ BACnetConstructedDataPulseConverterAdjustValue = (*_BACnetConstructedDataPulseConverterAdjustValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataPulseConverterAdjustValue)(nil)

// NewBACnetConstructedDataPulseConverterAdjustValue factory function for _BACnetConstructedDataPulseConverterAdjustValue
func NewBACnetConstructedDataPulseConverterAdjustValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, adjustValue BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPulseConverterAdjustValue {
	if adjustValue == nil {
		panic("adjustValue of type BACnetApplicationTagReal for BACnetConstructedDataPulseConverterAdjustValue must not be nil")
	}
	_result := &_BACnetConstructedDataPulseConverterAdjustValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AdjustValue:                   adjustValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataPulseConverterAdjustValueBuilder is a builder for BACnetConstructedDataPulseConverterAdjustValue
type BACnetConstructedDataPulseConverterAdjustValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(adjustValue BACnetApplicationTagReal) BACnetConstructedDataPulseConverterAdjustValueBuilder
	// WithAdjustValue adds AdjustValue (property field)
	WithAdjustValue(BACnetApplicationTagReal) BACnetConstructedDataPulseConverterAdjustValueBuilder
	// WithAdjustValueBuilder adds AdjustValue (property field) which is build by the builder
	WithAdjustValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataPulseConverterAdjustValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataPulseConverterAdjustValue or returns an error if something is wrong
	Build() (BACnetConstructedDataPulseConverterAdjustValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataPulseConverterAdjustValue
}

// NewBACnetConstructedDataPulseConverterAdjustValueBuilder() creates a BACnetConstructedDataPulseConverterAdjustValueBuilder
func NewBACnetConstructedDataPulseConverterAdjustValueBuilder() BACnetConstructedDataPulseConverterAdjustValueBuilder {
	return &_BACnetConstructedDataPulseConverterAdjustValueBuilder{_BACnetConstructedDataPulseConverterAdjustValue: new(_BACnetConstructedDataPulseConverterAdjustValue)}
}

type _BACnetConstructedDataPulseConverterAdjustValueBuilder struct {
	*_BACnetConstructedDataPulseConverterAdjustValue

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataPulseConverterAdjustValueBuilder) = (*_BACnetConstructedDataPulseConverterAdjustValueBuilder)(nil)

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataPulseConverterAdjustValue
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) WithMandatoryFields(adjustValue BACnetApplicationTagReal) BACnetConstructedDataPulseConverterAdjustValueBuilder {
	return b.WithAdjustValue(adjustValue)
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) WithAdjustValue(adjustValue BACnetApplicationTagReal) BACnetConstructedDataPulseConverterAdjustValueBuilder {
	b.AdjustValue = adjustValue
	return b
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) WithAdjustValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataPulseConverterAdjustValueBuilder {
	builder := builderSupplier(b.AdjustValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.AdjustValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) Build() (BACnetConstructedDataPulseConverterAdjustValue, error) {
	if b.AdjustValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'adjustValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataPulseConverterAdjustValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) MustBuild() BACnetConstructedDataPulseConverterAdjustValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataPulseConverterAdjustValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataPulseConverterAdjustValueBuilder().(*_BACnetConstructedDataPulseConverterAdjustValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataPulseConverterAdjustValueBuilder creates a BACnetConstructedDataPulseConverterAdjustValueBuilder
func (b *_BACnetConstructedDataPulseConverterAdjustValue) CreateBACnetConstructedDataPulseConverterAdjustValueBuilder() BACnetConstructedDataPulseConverterAdjustValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataPulseConverterAdjustValueBuilder()
	}
	return &_BACnetConstructedDataPulseConverterAdjustValueBuilder{_BACnetConstructedDataPulseConverterAdjustValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_PULSE_CONVERTER
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ADJUST_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetAdjustValue() BACnetApplicationTagReal {
	return m.AdjustValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetAdjustValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPulseConverterAdjustValue(structType any) BACnetConstructedDataPulseConverterAdjustValue {
	if casted, ok := structType.(BACnetConstructedDataPulseConverterAdjustValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPulseConverterAdjustValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetTypeName() string {
	return "BACnetConstructedDataPulseConverterAdjustValue"
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (adjustValue)
	lengthInBits += m.AdjustValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataPulseConverterAdjustValue BACnetConstructedDataPulseConverterAdjustValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPulseConverterAdjustValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPulseConverterAdjustValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	adjustValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "adjustValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'adjustValue' field"))
	}
	m.AdjustValue = adjustValue

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), adjustValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPulseConverterAdjustValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPulseConverterAdjustValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPulseConverterAdjustValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPulseConverterAdjustValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "adjustValue", m.GetAdjustValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'adjustValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPulseConverterAdjustValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPulseConverterAdjustValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) IsBACnetConstructedDataPulseConverterAdjustValue() {
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) deepCopy() *_BACnetConstructedDataPulseConverterAdjustValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataPulseConverterAdjustValueCopy := &_BACnetConstructedDataPulseConverterAdjustValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.AdjustValue),
	}
	_BACnetConstructedDataPulseConverterAdjustValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataPulseConverterAdjustValueCopy
}

func (m *_BACnetConstructedDataPulseConverterAdjustValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
