/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetContextTagObjectIdentifier is the corresponding interface of BACnetContextTagObjectIdentifier
type BACnetContextTagObjectIdentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetContextTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadObjectIdentifier
	// GetObjectType returns ObjectType (virtual field)
	GetObjectType() BACnetObjectType
	// GetInstanceNumber returns InstanceNumber (virtual field)
	GetInstanceNumber() uint32
	// IsBACnetContextTagObjectIdentifier is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetContextTagObjectIdentifier()
	// CreateBuilder creates a BACnetContextTagObjectIdentifierBuilder
	CreateBACnetContextTagObjectIdentifierBuilder() BACnetContextTagObjectIdentifierBuilder
}

// _BACnetContextTagObjectIdentifier is the data-structure of this message
type _BACnetContextTagObjectIdentifier struct {
	BACnetContextTagContract
	Payload BACnetTagPayloadObjectIdentifier
}

var _ BACnetContextTagObjectIdentifier = (*_BACnetContextTagObjectIdentifier)(nil)
var _ BACnetContextTagRequirements = (*_BACnetContextTagObjectIdentifier)(nil)

// NewBACnetContextTagObjectIdentifier factory function for _BACnetContextTagObjectIdentifier
func NewBACnetContextTagObjectIdentifier(header BACnetTagHeader, payload BACnetTagPayloadObjectIdentifier, tagNumberArgument uint8) *_BACnetContextTagObjectIdentifier {
	if payload == nil {
		panic("payload of type BACnetTagPayloadObjectIdentifier for BACnetContextTagObjectIdentifier must not be nil")
	}
	_result := &_BACnetContextTagObjectIdentifier{
		BACnetContextTagContract: NewBACnetContextTag(header, tagNumberArgument),
		Payload:                  payload,
	}
	_result.BACnetContextTagContract.(*_BACnetContextTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetContextTagObjectIdentifierBuilder is a builder for BACnetContextTagObjectIdentifier
type BACnetContextTagObjectIdentifierBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadObjectIdentifier) BACnetContextTagObjectIdentifierBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadObjectIdentifier) BACnetContextTagObjectIdentifierBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadObjectIdentifierBuilder) BACnetTagPayloadObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetContextTagBuilder
	// Build builds the BACnetContextTagObjectIdentifier or returns an error if something is wrong
	Build() (BACnetContextTagObjectIdentifier, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetContextTagObjectIdentifier
}

// NewBACnetContextTagObjectIdentifierBuilder() creates a BACnetContextTagObjectIdentifierBuilder
func NewBACnetContextTagObjectIdentifierBuilder() BACnetContextTagObjectIdentifierBuilder {
	return &_BACnetContextTagObjectIdentifierBuilder{_BACnetContextTagObjectIdentifier: new(_BACnetContextTagObjectIdentifier)}
}

type _BACnetContextTagObjectIdentifierBuilder struct {
	*_BACnetContextTagObjectIdentifier

	parentBuilder *_BACnetContextTagBuilder

	collectedErr []error
}

var _ (BACnetContextTagObjectIdentifierBuilder) = (*_BACnetContextTagObjectIdentifierBuilder)(nil)

func (b *_BACnetContextTagObjectIdentifierBuilder) setParent(contract BACnetContextTagContract) {
	b.BACnetContextTagContract = contract
	contract.(*_BACnetContextTag)._SubType = b._BACnetContextTagObjectIdentifier
}

func (b *_BACnetContextTagObjectIdentifierBuilder) WithMandatoryFields(payload BACnetTagPayloadObjectIdentifier) BACnetContextTagObjectIdentifierBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetContextTagObjectIdentifierBuilder) WithPayload(payload BACnetTagPayloadObjectIdentifier) BACnetContextTagObjectIdentifierBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetContextTagObjectIdentifierBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadObjectIdentifierBuilder) BACnetTagPayloadObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadObjectIdentifierBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagPayloadObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetContextTagObjectIdentifierBuilder) Build() (BACnetContextTagObjectIdentifier, error) {
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetContextTagObjectIdentifier.deepCopy(), nil
}

func (b *_BACnetContextTagObjectIdentifierBuilder) MustBuild() BACnetContextTagObjectIdentifier {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetContextTagObjectIdentifierBuilder) Done() BACnetContextTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetContextTagBuilder().(*_BACnetContextTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetContextTagObjectIdentifierBuilder) buildForBACnetContextTag() (BACnetContextTag, error) {
	return b.Build()
}

func (b *_BACnetContextTagObjectIdentifierBuilder) DeepCopy() any {
	_copy := b.CreateBACnetContextTagObjectIdentifierBuilder().(*_BACnetContextTagObjectIdentifierBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetContextTagObjectIdentifierBuilder creates a BACnetContextTagObjectIdentifierBuilder
func (b *_BACnetContextTagObjectIdentifier) CreateBACnetContextTagObjectIdentifierBuilder() BACnetContextTagObjectIdentifierBuilder {
	if b == nil {
		return NewBACnetContextTagObjectIdentifierBuilder()
	}
	return &_BACnetContextTagObjectIdentifierBuilder{_BACnetContextTagObjectIdentifier: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetContextTagObjectIdentifier) GetDataType() BACnetDataType {
	return BACnetDataType_BACNET_OBJECT_IDENTIFIER
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetContextTagObjectIdentifier) GetParent() BACnetContextTagContract {
	return m.BACnetContextTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetContextTagObjectIdentifier) GetPayload() BACnetTagPayloadObjectIdentifier {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetContextTagObjectIdentifier) GetObjectType() BACnetObjectType {
	ctx := context.Background()
	_ = ctx
	return CastBACnetObjectType(m.GetPayload().GetObjectType())
}

func (m *_BACnetContextTagObjectIdentifier) GetInstanceNumber() uint32 {
	ctx := context.Background()
	_ = ctx
	return uint32(m.GetPayload().GetInstanceNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetContextTagObjectIdentifier(structType any) BACnetContextTagObjectIdentifier {
	if casted, ok := structType.(BACnetContextTagObjectIdentifier); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetContextTagObjectIdentifier); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetContextTagObjectIdentifier) GetTypeName() string {
	return "BACnetContextTagObjectIdentifier"
}

func (m *_BACnetContextTagObjectIdentifier) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetContextTagContract.(*_BACnetContextTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetContextTagObjectIdentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetContextTagObjectIdentifier) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetContextTag, tagNumberArgument uint8, dataType BACnetDataType) (__bACnetContextTagObjectIdentifier BACnetContextTagObjectIdentifier, err error) {
	m.BACnetContextTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetContextTagObjectIdentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetContextTagObjectIdentifier")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadObjectIdentifier](ctx, "payload", ReadComplex[BACnetTagPayloadObjectIdentifier](BACnetTagPayloadObjectIdentifierParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	objectType, err := ReadVirtualField[BACnetObjectType](ctx, "objectType", (*BACnetObjectType)(nil), payload.GetObjectType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectType' field"))
	}
	_ = objectType

	instanceNumber, err := ReadVirtualField[uint32](ctx, "instanceNumber", (*uint32)(nil), payload.GetInstanceNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'instanceNumber' field"))
	}
	_ = instanceNumber

	if closeErr := readBuffer.CloseContext("BACnetContextTagObjectIdentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetContextTagObjectIdentifier")
	}

	return m, nil
}

func (m *_BACnetContextTagObjectIdentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetContextTagObjectIdentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetContextTagObjectIdentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetContextTagObjectIdentifier")
		}

		if err := WriteSimpleField[BACnetTagPayloadObjectIdentifier](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}
		// Virtual field
		objectType := m.GetObjectType()
		_ = objectType
		if _objectTypeErr := writeBuffer.WriteVirtual(ctx, "objectType", m.GetObjectType()); _objectTypeErr != nil {
			return errors.Wrap(_objectTypeErr, "Error serializing 'objectType' field")
		}
		// Virtual field
		instanceNumber := m.GetInstanceNumber()
		_ = instanceNumber
		if _instanceNumberErr := writeBuffer.WriteVirtual(ctx, "instanceNumber", m.GetInstanceNumber()); _instanceNumberErr != nil {
			return errors.Wrap(_instanceNumberErr, "Error serializing 'instanceNumber' field")
		}

		if popErr := writeBuffer.PopContext("BACnetContextTagObjectIdentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetContextTagObjectIdentifier")
		}
		return nil
	}
	return m.BACnetContextTagContract.(*_BACnetContextTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetContextTagObjectIdentifier) IsBACnetContextTagObjectIdentifier() {}

func (m *_BACnetContextTagObjectIdentifier) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetContextTagObjectIdentifier) deepCopy() *_BACnetContextTagObjectIdentifier {
	if m == nil {
		return nil
	}
	_BACnetContextTagObjectIdentifierCopy := &_BACnetContextTagObjectIdentifier{
		m.BACnetContextTagContract.(*_BACnetContextTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadObjectIdentifier](m.Payload),
	}
	_BACnetContextTagObjectIdentifierCopy.BACnetContextTagContract.(*_BACnetContextTag)._SubType = m
	return _BACnetContextTagObjectIdentifierCopy
}

func (m *_BACnetContextTagObjectIdentifier) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
