/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventParameterExtendedParameters is the corresponding interface of BACnetEventParameterExtendedParameters
type BACnetEventParameterExtendedParameters interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetNullValue returns NullValue (property field)
	GetNullValue() BACnetApplicationTagNull
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetApplicationTagUnsignedInteger
	// GetBooleanValue returns BooleanValue (property field)
	GetBooleanValue() BACnetApplicationTagBoolean
	// GetIntegerValue returns IntegerValue (property field)
	GetIntegerValue() BACnetApplicationTagSignedInteger
	// GetDoubleValue returns DoubleValue (property field)
	GetDoubleValue() BACnetApplicationTagDouble
	// GetOctetStringValue returns OctetStringValue (property field)
	GetOctetStringValue() BACnetApplicationTagOctetString
	// GetCharacterStringValue returns CharacterStringValue (property field)
	GetCharacterStringValue() BACnetApplicationTagCharacterString
	// GetBitStringValue returns BitStringValue (property field)
	GetBitStringValue() BACnetApplicationTagBitString
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// GetDateValue returns DateValue (property field)
	GetDateValue() BACnetApplicationTagDate
	// GetTimeValue returns TimeValue (property field)
	GetTimeValue() BACnetApplicationTagTime
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetApplicationTagObjectIdentifier
	// GetReference returns Reference (property field)
	GetReference() BACnetDeviceObjectPropertyReferenceEnclosed
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetIsOpeningTag returns IsOpeningTag (virtual field)
	GetIsOpeningTag() bool
	// GetIsClosingTag returns IsClosingTag (virtual field)
	GetIsClosingTag() bool
	// IsBACnetEventParameterExtendedParameters is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventParameterExtendedParameters()
	// CreateBuilder creates a BACnetEventParameterExtendedParametersBuilder
	CreateBACnetEventParameterExtendedParametersBuilder() BACnetEventParameterExtendedParametersBuilder
}

// _BACnetEventParameterExtendedParameters is the data-structure of this message
type _BACnetEventParameterExtendedParameters struct {
	OpeningTag           BACnetOpeningTag
	PeekedTagHeader      BACnetTagHeader
	NullValue            BACnetApplicationTagNull
	RealValue            BACnetApplicationTagReal
	UnsignedValue        BACnetApplicationTagUnsignedInteger
	BooleanValue         BACnetApplicationTagBoolean
	IntegerValue         BACnetApplicationTagSignedInteger
	DoubleValue          BACnetApplicationTagDouble
	OctetStringValue     BACnetApplicationTagOctetString
	CharacterStringValue BACnetApplicationTagCharacterString
	BitStringValue       BACnetApplicationTagBitString
	EnumeratedValue      BACnetApplicationTagEnumerated
	DateValue            BACnetApplicationTagDate
	TimeValue            BACnetApplicationTagTime
	ObjectIdentifier     BACnetApplicationTagObjectIdentifier
	Reference            BACnetDeviceObjectPropertyReferenceEnclosed
	ClosingTag           BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetEventParameterExtendedParameters = (*_BACnetEventParameterExtendedParameters)(nil)

// NewBACnetEventParameterExtendedParameters factory function for _BACnetEventParameterExtendedParameters
func NewBACnetEventParameterExtendedParameters(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, nullValue BACnetApplicationTagNull, realValue BACnetApplicationTagReal, unsignedValue BACnetApplicationTagUnsignedInteger, booleanValue BACnetApplicationTagBoolean, integerValue BACnetApplicationTagSignedInteger, doubleValue BACnetApplicationTagDouble, octetStringValue BACnetApplicationTagOctetString, characterStringValue BACnetApplicationTagCharacterString, bitStringValue BACnetApplicationTagBitString, enumeratedValue BACnetApplicationTagEnumerated, dateValue BACnetApplicationTagDate, timeValue BACnetApplicationTagTime, objectIdentifier BACnetApplicationTagObjectIdentifier, reference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetEventParameterExtendedParameters {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetEventParameterExtendedParameters must not be nil")
	}
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetEventParameterExtendedParameters must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetEventParameterExtendedParameters must not be nil")
	}
	return &_BACnetEventParameterExtendedParameters{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, NullValue: nullValue, RealValue: realValue, UnsignedValue: unsignedValue, BooleanValue: booleanValue, IntegerValue: integerValue, DoubleValue: doubleValue, OctetStringValue: octetStringValue, CharacterStringValue: characterStringValue, BitStringValue: bitStringValue, EnumeratedValue: enumeratedValue, DateValue: dateValue, TimeValue: timeValue, ObjectIdentifier: objectIdentifier, Reference: reference, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventParameterExtendedParametersBuilder is a builder for BACnetEventParameterExtendedParameters
type BACnetEventParameterExtendedParametersBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetEventParameterExtendedParametersBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetEventParameterExtendedParametersBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetEventParameterExtendedParametersBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithNullValue adds NullValue (property field)
	WithOptionalNullValue(BACnetApplicationTagNull) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalNullValueBuilder adds NullValue (property field) which is build by the builder
	WithOptionalNullValueBuilder(func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithRealValue adds RealValue (property field)
	WithOptionalRealValue(BACnetApplicationTagReal) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalRealValueBuilder adds RealValue (property field) which is build by the builder
	WithOptionalRealValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithUnsignedValue adds UnsignedValue (property field)
	WithOptionalUnsignedValue(BACnetApplicationTagUnsignedInteger) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalUnsignedValueBuilder adds UnsignedValue (property field) which is build by the builder
	WithOptionalUnsignedValueBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithBooleanValue adds BooleanValue (property field)
	WithOptionalBooleanValue(BACnetApplicationTagBoolean) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalBooleanValueBuilder adds BooleanValue (property field) which is build by the builder
	WithOptionalBooleanValueBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithIntegerValue adds IntegerValue (property field)
	WithOptionalIntegerValue(BACnetApplicationTagSignedInteger) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalIntegerValueBuilder adds IntegerValue (property field) which is build by the builder
	WithOptionalIntegerValueBuilder(func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithDoubleValue adds DoubleValue (property field)
	WithOptionalDoubleValue(BACnetApplicationTagDouble) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalDoubleValueBuilder adds DoubleValue (property field) which is build by the builder
	WithOptionalDoubleValueBuilder(func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithOctetStringValue adds OctetStringValue (property field)
	WithOptionalOctetStringValue(BACnetApplicationTagOctetString) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalOctetStringValueBuilder adds OctetStringValue (property field) which is build by the builder
	WithOptionalOctetStringValueBuilder(func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithCharacterStringValue adds CharacterStringValue (property field)
	WithOptionalCharacterStringValue(BACnetApplicationTagCharacterString) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalCharacterStringValueBuilder adds CharacterStringValue (property field) which is build by the builder
	WithOptionalCharacterStringValueBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithBitStringValue adds BitStringValue (property field)
	WithOptionalBitStringValue(BACnetApplicationTagBitString) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalBitStringValueBuilder adds BitStringValue (property field) which is build by the builder
	WithOptionalBitStringValueBuilder(func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithEnumeratedValue adds EnumeratedValue (property field)
	WithOptionalEnumeratedValue(BACnetApplicationTagEnumerated) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalEnumeratedValueBuilder adds EnumeratedValue (property field) which is build by the builder
	WithOptionalEnumeratedValueBuilder(func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithDateValue adds DateValue (property field)
	WithOptionalDateValue(BACnetApplicationTagDate) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalDateValueBuilder adds DateValue (property field) which is build by the builder
	WithOptionalDateValueBuilder(func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithTimeValue adds TimeValue (property field)
	WithOptionalTimeValue(BACnetApplicationTagTime) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalTimeValueBuilder adds TimeValue (property field) which is build by the builder
	WithOptionalTimeValueBuilder(func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithOptionalObjectIdentifier(BACnetApplicationTagObjectIdentifier) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithOptionalObjectIdentifierBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithReference adds Reference (property field)
	WithOptionalReference(BACnetDeviceObjectPropertyReferenceEnclosed) BACnetEventParameterExtendedParametersBuilder
	// WithOptionalReferenceBuilder adds Reference (property field) which is build by the builder
	WithOptionalReferenceBuilder(func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetEventParameterExtendedParametersBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterExtendedParametersBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventParameterExtendedParametersBuilder
	// Build builds the BACnetEventParameterExtendedParameters or returns an error if something is wrong
	Build() (BACnetEventParameterExtendedParameters, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventParameterExtendedParameters
}

// NewBACnetEventParameterExtendedParametersBuilder() creates a BACnetEventParameterExtendedParametersBuilder
func NewBACnetEventParameterExtendedParametersBuilder() BACnetEventParameterExtendedParametersBuilder {
	return &_BACnetEventParameterExtendedParametersBuilder{_BACnetEventParameterExtendedParameters: new(_BACnetEventParameterExtendedParameters)}
}

type _BACnetEventParameterExtendedParametersBuilder struct {
	*_BACnetEventParameterExtendedParameters

	collectedErr []error
}

var _ (BACnetEventParameterExtendedParametersBuilder) = (*_BACnetEventParameterExtendedParametersBuilder)(nil)

func (b *_BACnetEventParameterExtendedParametersBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetEventParameterExtendedParametersBuilder {
	return b.WithOpeningTag(openingTag).WithPeekedTagHeader(peekedTagHeader).WithClosingTag(closingTag)
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetEventParameterExtendedParametersBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetEventParameterExtendedParametersBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalNullValue(nullValue BACnetApplicationTagNull) BACnetEventParameterExtendedParametersBuilder {
	b.NullValue = nullValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalNullValueBuilder(builderSupplier func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.NullValue.CreateBACnetApplicationTagNullBuilder())
	var err error
	b.NullValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagNullBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalRealValue(realValue BACnetApplicationTagReal) BACnetEventParameterExtendedParametersBuilder {
	b.RealValue = realValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalRealValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.RealValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalUnsignedValue(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetEventParameterExtendedParametersBuilder {
	b.UnsignedValue = unsignedValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalUnsignedValueBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.UnsignedValue.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.UnsignedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalBooleanValue(booleanValue BACnetApplicationTagBoolean) BACnetEventParameterExtendedParametersBuilder {
	b.BooleanValue = booleanValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalBooleanValueBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.BooleanValue.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.BooleanValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalIntegerValue(integerValue BACnetApplicationTagSignedInteger) BACnetEventParameterExtendedParametersBuilder {
	b.IntegerValue = integerValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalIntegerValueBuilder(builderSupplier func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.IntegerValue.CreateBACnetApplicationTagSignedIntegerBuilder())
	var err error
	b.IntegerValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagSignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalDoubleValue(doubleValue BACnetApplicationTagDouble) BACnetEventParameterExtendedParametersBuilder {
	b.DoubleValue = doubleValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalDoubleValueBuilder(builderSupplier func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.DoubleValue.CreateBACnetApplicationTagDoubleBuilder())
	var err error
	b.DoubleValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDoubleBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalOctetStringValue(octetStringValue BACnetApplicationTagOctetString) BACnetEventParameterExtendedParametersBuilder {
	b.OctetStringValue = octetStringValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalOctetStringValueBuilder(builderSupplier func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.OctetStringValue.CreateBACnetApplicationTagOctetStringBuilder())
	var err error
	b.OctetStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalCharacterStringValue(characterStringValue BACnetApplicationTagCharacterString) BACnetEventParameterExtendedParametersBuilder {
	b.CharacterStringValue = characterStringValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalCharacterStringValueBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.CharacterStringValue.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.CharacterStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalBitStringValue(bitStringValue BACnetApplicationTagBitString) BACnetEventParameterExtendedParametersBuilder {
	b.BitStringValue = bitStringValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalBitStringValueBuilder(builderSupplier func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.BitStringValue.CreateBACnetApplicationTagBitStringBuilder())
	var err error
	b.BitStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalEnumeratedValue(enumeratedValue BACnetApplicationTagEnumerated) BACnetEventParameterExtendedParametersBuilder {
	b.EnumeratedValue = enumeratedValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalEnumeratedValueBuilder(builderSupplier func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.EnumeratedValue.CreateBACnetApplicationTagEnumeratedBuilder())
	var err error
	b.EnumeratedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagEnumeratedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalDateValue(dateValue BACnetApplicationTagDate) BACnetEventParameterExtendedParametersBuilder {
	b.DateValue = dateValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalDateValueBuilder(builderSupplier func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.DateValue.CreateBACnetApplicationTagDateBuilder())
	var err error
	b.DateValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDateBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalTimeValue(timeValue BACnetApplicationTagTime) BACnetEventParameterExtendedParametersBuilder {
	b.TimeValue = timeValue
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalTimeValueBuilder(builderSupplier func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.TimeValue.CreateBACnetApplicationTagTimeBuilder())
	var err error
	b.TimeValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalObjectIdentifier(objectIdentifier BACnetApplicationTagObjectIdentifier) BACnetEventParameterExtendedParametersBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalObjectIdentifierBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalReference(reference BACnetDeviceObjectPropertyReferenceEnclosed) BACnetEventParameterExtendedParametersBuilder {
	b.Reference = reference
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithOptionalReferenceBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.Reference.CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder())
	var err error
	b.Reference, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetEventParameterExtendedParametersBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterExtendedParametersBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventParameterExtendedParametersBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetEventParameterExtendedParametersBuilder) Build() (BACnetEventParameterExtendedParameters, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PeekedTagHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventParameterExtendedParameters.deepCopy(), nil
}

func (b *_BACnetEventParameterExtendedParametersBuilder) MustBuild() BACnetEventParameterExtendedParameters {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventParameterExtendedParametersBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventParameterExtendedParametersBuilder().(*_BACnetEventParameterExtendedParametersBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventParameterExtendedParametersBuilder creates a BACnetEventParameterExtendedParametersBuilder
func (b *_BACnetEventParameterExtendedParameters) CreateBACnetEventParameterExtendedParametersBuilder() BACnetEventParameterExtendedParametersBuilder {
	if b == nil {
		return NewBACnetEventParameterExtendedParametersBuilder()
	}
	return &_BACnetEventParameterExtendedParametersBuilder{_BACnetEventParameterExtendedParameters: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventParameterExtendedParameters) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetEventParameterExtendedParameters) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetEventParameterExtendedParameters) GetNullValue() BACnetApplicationTagNull {
	return m.NullValue
}

func (m *_BACnetEventParameterExtendedParameters) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

func (m *_BACnetEventParameterExtendedParameters) GetUnsignedValue() BACnetApplicationTagUnsignedInteger {
	return m.UnsignedValue
}

func (m *_BACnetEventParameterExtendedParameters) GetBooleanValue() BACnetApplicationTagBoolean {
	return m.BooleanValue
}

func (m *_BACnetEventParameterExtendedParameters) GetIntegerValue() BACnetApplicationTagSignedInteger {
	return m.IntegerValue
}

func (m *_BACnetEventParameterExtendedParameters) GetDoubleValue() BACnetApplicationTagDouble {
	return m.DoubleValue
}

func (m *_BACnetEventParameterExtendedParameters) GetOctetStringValue() BACnetApplicationTagOctetString {
	return m.OctetStringValue
}

func (m *_BACnetEventParameterExtendedParameters) GetCharacterStringValue() BACnetApplicationTagCharacterString {
	return m.CharacterStringValue
}

func (m *_BACnetEventParameterExtendedParameters) GetBitStringValue() BACnetApplicationTagBitString {
	return m.BitStringValue
}

func (m *_BACnetEventParameterExtendedParameters) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

func (m *_BACnetEventParameterExtendedParameters) GetDateValue() BACnetApplicationTagDate {
	return m.DateValue
}

func (m *_BACnetEventParameterExtendedParameters) GetTimeValue() BACnetApplicationTagTime {
	return m.TimeValue
}

func (m *_BACnetEventParameterExtendedParameters) GetObjectIdentifier() BACnetApplicationTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetEventParameterExtendedParameters) GetReference() BACnetDeviceObjectPropertyReferenceEnclosed {
	return m.Reference
}

func (m *_BACnetEventParameterExtendedParameters) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEventParameterExtendedParameters) GetPeekedTagNumber() uint8 {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

func (m *_BACnetEventParameterExtendedParameters) GetIsOpeningTag() bool {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x6)))
}

func (m *_BACnetEventParameterExtendedParameters) GetIsClosingTag() bool {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x7)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventParameterExtendedParameters(structType any) BACnetEventParameterExtendedParameters {
	if casted, ok := structType.(BACnetEventParameterExtendedParameters); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventParameterExtendedParameters); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventParameterExtendedParameters) GetTypeName() string {
	return "BACnetEventParameterExtendedParameters"
}

func (m *_BACnetEventParameterExtendedParameters) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// Optional Field (nullValue)
	if m.NullValue != nil {
		lengthInBits += m.NullValue.GetLengthInBits(ctx)
	}

	// Optional Field (realValue)
	if m.RealValue != nil {
		lengthInBits += m.RealValue.GetLengthInBits(ctx)
	}

	// Optional Field (unsignedValue)
	if m.UnsignedValue != nil {
		lengthInBits += m.UnsignedValue.GetLengthInBits(ctx)
	}

	// Optional Field (booleanValue)
	if m.BooleanValue != nil {
		lengthInBits += m.BooleanValue.GetLengthInBits(ctx)
	}

	// Optional Field (integerValue)
	if m.IntegerValue != nil {
		lengthInBits += m.IntegerValue.GetLengthInBits(ctx)
	}

	// Optional Field (doubleValue)
	if m.DoubleValue != nil {
		lengthInBits += m.DoubleValue.GetLengthInBits(ctx)
	}

	// Optional Field (octetStringValue)
	if m.OctetStringValue != nil {
		lengthInBits += m.OctetStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (characterStringValue)
	if m.CharacterStringValue != nil {
		lengthInBits += m.CharacterStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (bitStringValue)
	if m.BitStringValue != nil {
		lengthInBits += m.BitStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (enumeratedValue)
	if m.EnumeratedValue != nil {
		lengthInBits += m.EnumeratedValue.GetLengthInBits(ctx)
	}

	// Optional Field (dateValue)
	if m.DateValue != nil {
		lengthInBits += m.DateValue.GetLengthInBits(ctx)
	}

	// Optional Field (timeValue)
	if m.TimeValue != nil {
		lengthInBits += m.TimeValue.GetLengthInBits(ctx)
	}

	// Optional Field (objectIdentifier)
	if m.ObjectIdentifier != nil {
		lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)
	}

	// Optional Field (reference)
	if m.Reference != nil {
		lengthInBits += m.Reference.GetLengthInBits(ctx)
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventParameterExtendedParameters) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventParameterExtendedParametersParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetEventParameterExtendedParameters, error) {
	return BACnetEventParameterExtendedParametersParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetEventParameterExtendedParametersParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventParameterExtendedParameters, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventParameterExtendedParameters, error) {
		return BACnetEventParameterExtendedParametersParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetEventParameterExtendedParametersParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetEventParameterExtendedParameters, error) {
	v, err := (&_BACnetEventParameterExtendedParameters{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventParameterExtendedParameters) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetEventParameterExtendedParameters BACnetEventParameterExtendedParameters, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventParameterExtendedParameters"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventParameterExtendedParameters")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	isOpeningTag, err := ReadVirtualField[bool](ctx, "isOpeningTag", (*bool)(nil), bool((peekedTagHeader.GetLengthValueType()) == (0x6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isOpeningTag' field"))
	}
	_ = isOpeningTag

	isClosingTag, err := ReadVirtualField[bool](ctx, "isClosingTag", (*bool)(nil), bool((peekedTagHeader.GetLengthValueType()) == (0x7)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isClosingTag' field"))
	}
	_ = isClosingTag

	var nullValue BACnetApplicationTagNull
	_nullValue, err := ReadOptionalField[BACnetApplicationTagNull](ctx, "nullValue", ReadComplex[BACnetApplicationTagNull](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagNull](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x0))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nullValue' field"))
	}
	if _nullValue != nil {
		nullValue = *_nullValue
		m.NullValue = nullValue
	}

	var realValue BACnetApplicationTagReal
	_realValue, err := ReadOptionalField[BACnetApplicationTagReal](ctx, "realValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x4))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realValue' field"))
	}
	if _realValue != nil {
		realValue = *_realValue
		m.RealValue = realValue
	}

	var unsignedValue BACnetApplicationTagUnsignedInteger
	_unsignedValue, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x2))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unsignedValue' field"))
	}
	if _unsignedValue != nil {
		unsignedValue = *_unsignedValue
		m.UnsignedValue = unsignedValue
	}

	var booleanValue BACnetApplicationTagBoolean
	_booleanValue, err := ReadOptionalField[BACnetApplicationTagBoolean](ctx, "booleanValue", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x1))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'booleanValue' field"))
	}
	if _booleanValue != nil {
		booleanValue = *_booleanValue
		m.BooleanValue = booleanValue
	}

	var integerValue BACnetApplicationTagSignedInteger
	_integerValue, err := ReadOptionalField[BACnetApplicationTagSignedInteger](ctx, "integerValue", ReadComplex[BACnetApplicationTagSignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagSignedInteger](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x3))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'integerValue' field"))
	}
	if _integerValue != nil {
		integerValue = *_integerValue
		m.IntegerValue = integerValue
	}

	var doubleValue BACnetApplicationTagDouble
	_doubleValue, err := ReadOptionalField[BACnetApplicationTagDouble](ctx, "doubleValue", ReadComplex[BACnetApplicationTagDouble](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDouble](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x5))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doubleValue' field"))
	}
	if _doubleValue != nil {
		doubleValue = *_doubleValue
		m.DoubleValue = doubleValue
	}

	var octetStringValue BACnetApplicationTagOctetString
	_octetStringValue, err := ReadOptionalField[BACnetApplicationTagOctetString](ctx, "octetStringValue", ReadComplex[BACnetApplicationTagOctetString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagOctetString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x6))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'octetStringValue' field"))
	}
	if _octetStringValue != nil {
		octetStringValue = *_octetStringValue
		m.OctetStringValue = octetStringValue
	}

	var characterStringValue BACnetApplicationTagCharacterString
	_characterStringValue, err := ReadOptionalField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x7))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'characterStringValue' field"))
	}
	if _characterStringValue != nil {
		characterStringValue = *_characterStringValue
		m.CharacterStringValue = characterStringValue
	}

	var bitStringValue BACnetApplicationTagBitString
	_bitStringValue, err := ReadOptionalField[BACnetApplicationTagBitString](ctx, "bitStringValue", ReadComplex[BACnetApplicationTagBitString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBitString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x8))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bitStringValue' field"))
	}
	if _bitStringValue != nil {
		bitStringValue = *_bitStringValue
		m.BitStringValue = bitStringValue
	}

	var enumeratedValue BACnetApplicationTagEnumerated
	_enumeratedValue, err := ReadOptionalField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", ReadComplex[BACnetApplicationTagEnumerated](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagEnumerated](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x9))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumeratedValue' field"))
	}
	if _enumeratedValue != nil {
		enumeratedValue = *_enumeratedValue
		m.EnumeratedValue = enumeratedValue
	}

	var dateValue BACnetApplicationTagDate
	_dateValue, err := ReadOptionalField[BACnetApplicationTagDate](ctx, "dateValue", ReadComplex[BACnetApplicationTagDate](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDate](), readBuffer), bool(bool(bool((peekedTagNumber) == (0xA))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateValue' field"))
	}
	if _dateValue != nil {
		dateValue = *_dateValue
		m.DateValue = dateValue
	}

	var timeValue BACnetApplicationTagTime
	_timeValue, err := ReadOptionalField[BACnetApplicationTagTime](ctx, "timeValue", ReadComplex[BACnetApplicationTagTime](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagTime](), readBuffer), bool(bool(bool((peekedTagNumber) == (0xB))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeValue' field"))
	}
	if _timeValue != nil {
		timeValue = *_timeValue
		m.TimeValue = timeValue
	}

	var objectIdentifier BACnetApplicationTagObjectIdentifier
	_objectIdentifier, err := ReadOptionalField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer), bool(bool((peekedTagNumber) == (0xC))) && bool(!(isOpeningTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	if _objectIdentifier != nil {
		objectIdentifier = *_objectIdentifier
		m.ObjectIdentifier = objectIdentifier
	}

	var reference BACnetDeviceObjectPropertyReferenceEnclosed
	_reference, err := ReadOptionalField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "reference", ReadComplex[BACnetDeviceObjectPropertyReferenceEnclosed](BACnetDeviceObjectPropertyReferenceEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer), bool(isOpeningTag) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'reference' field"))
	}
	if _reference != nil {
		reference = *_reference
		m.Reference = reference
	}

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetEventParameterExtendedParameters"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventParameterExtendedParameters")
	}

	return m, nil
}

func (m *_BACnetEventParameterExtendedParameters) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventParameterExtendedParameters) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventParameterExtendedParameters"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventParameterExtendedParameters")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}
	// Virtual field
	isOpeningTag := m.GetIsOpeningTag()
	_ = isOpeningTag
	if _isOpeningTagErr := writeBuffer.WriteVirtual(ctx, "isOpeningTag", m.GetIsOpeningTag()); _isOpeningTagErr != nil {
		return errors.Wrap(_isOpeningTagErr, "Error serializing 'isOpeningTag' field")
	}
	// Virtual field
	isClosingTag := m.GetIsClosingTag()
	_ = isClosingTag
	if _isClosingTagErr := writeBuffer.WriteVirtual(ctx, "isClosingTag", m.GetIsClosingTag()); _isClosingTagErr != nil {
		return errors.Wrap(_isClosingTagErr, "Error serializing 'isClosingTag' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagNull](ctx, "nullValue", GetRef(m.GetNullValue()), WriteComplex[BACnetApplicationTagNull](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'nullValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagReal](ctx, "realValue", GetRef(m.GetRealValue()), WriteComplex[BACnetApplicationTagReal](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'realValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", GetRef(m.GetUnsignedValue()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'unsignedValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagBoolean](ctx, "booleanValue", GetRef(m.GetBooleanValue()), WriteComplex[BACnetApplicationTagBoolean](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'booleanValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagSignedInteger](ctx, "integerValue", GetRef(m.GetIntegerValue()), WriteComplex[BACnetApplicationTagSignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'integerValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagDouble](ctx, "doubleValue", GetRef(m.GetDoubleValue()), WriteComplex[BACnetApplicationTagDouble](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'doubleValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagOctetString](ctx, "octetStringValue", GetRef(m.GetOctetStringValue()), WriteComplex[BACnetApplicationTagOctetString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'octetStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", GetRef(m.GetCharacterStringValue()), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'characterStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagBitString](ctx, "bitStringValue", GetRef(m.GetBitStringValue()), WriteComplex[BACnetApplicationTagBitString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'bitStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", GetRef(m.GetEnumeratedValue()), WriteComplex[BACnetApplicationTagEnumerated](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'enumeratedValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagDate](ctx, "dateValue", GetRef(m.GetDateValue()), WriteComplex[BACnetApplicationTagDate](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'dateValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagTime](ctx, "timeValue", GetRef(m.GetTimeValue()), WriteComplex[BACnetApplicationTagTime](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'timeValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", GetRef(m.GetObjectIdentifier()), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteOptionalField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "reference", GetRef(m.GetReference()), WriteComplex[BACnetDeviceObjectPropertyReferenceEnclosed](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'reference' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventParameterExtendedParameters"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventParameterExtendedParameters")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventParameterExtendedParameters) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetEventParameterExtendedParameters) IsBACnetEventParameterExtendedParameters() {}

func (m *_BACnetEventParameterExtendedParameters) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventParameterExtendedParameters) deepCopy() *_BACnetEventParameterExtendedParameters {
	if m == nil {
		return nil
	}
	_BACnetEventParameterExtendedParametersCopy := &_BACnetEventParameterExtendedParameters{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		utils.DeepCopy[BACnetApplicationTagNull](m.NullValue),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealValue),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.UnsignedValue),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.BooleanValue),
		utils.DeepCopy[BACnetApplicationTagSignedInteger](m.IntegerValue),
		utils.DeepCopy[BACnetApplicationTagDouble](m.DoubleValue),
		utils.DeepCopy[BACnetApplicationTagOctetString](m.OctetStringValue),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.CharacterStringValue),
		utils.DeepCopy[BACnetApplicationTagBitString](m.BitStringValue),
		utils.DeepCopy[BACnetApplicationTagEnumerated](m.EnumeratedValue),
		utils.DeepCopy[BACnetApplicationTagDate](m.DateValue),
		utils.DeepCopy[BACnetApplicationTagTime](m.TimeValue),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetDeviceObjectPropertyReferenceEnclosed](m.Reference),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetEventParameterExtendedParametersCopy
}

func (m *_BACnetEventParameterExtendedParameters) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
