/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventSummary is the corresponding interface of BACnetEventSummary
type BACnetEventSummary interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetEventState returns EventState (property field)
	GetEventState() BACnetEventStateTagged
	// GetAcknowledgedTransitions returns AcknowledgedTransitions (property field)
	GetAcknowledgedTransitions() BACnetEventTransitionBitsTagged
	// GetEventTimestamps returns EventTimestamps (property field)
	GetEventTimestamps() BACnetEventTimestampsEnclosed
	// GetNotifyType returns NotifyType (property field)
	GetNotifyType() BACnetNotifyTypeTagged
	// GetEventEnable returns EventEnable (property field)
	GetEventEnable() BACnetEventTransitionBitsTagged
	// GetEventPriorities returns EventPriorities (property field)
	GetEventPriorities() BACnetEventPriorities
	// IsBACnetEventSummary is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventSummary()
	// CreateBuilder creates a BACnetEventSummaryBuilder
	CreateBACnetEventSummaryBuilder() BACnetEventSummaryBuilder
}

// _BACnetEventSummary is the data-structure of this message
type _BACnetEventSummary struct {
	ObjectIdentifier        BACnetContextTagObjectIdentifier
	EventState              BACnetEventStateTagged
	AcknowledgedTransitions BACnetEventTransitionBitsTagged
	EventTimestamps         BACnetEventTimestampsEnclosed
	NotifyType              BACnetNotifyTypeTagged
	EventEnable             BACnetEventTransitionBitsTagged
	EventPriorities         BACnetEventPriorities
}

var _ BACnetEventSummary = (*_BACnetEventSummary)(nil)

// NewBACnetEventSummary factory function for _BACnetEventSummary
func NewBACnetEventSummary(objectIdentifier BACnetContextTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged, eventTimestamps BACnetEventTimestampsEnclosed, notifyType BACnetNotifyTypeTagged, eventEnable BACnetEventTransitionBitsTagged, eventPriorities BACnetEventPriorities) *_BACnetEventSummary {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetEventSummary must not be nil")
	}
	if eventState == nil {
		panic("eventState of type BACnetEventStateTagged for BACnetEventSummary must not be nil")
	}
	if acknowledgedTransitions == nil {
		panic("acknowledgedTransitions of type BACnetEventTransitionBitsTagged for BACnetEventSummary must not be nil")
	}
	if eventTimestamps == nil {
		panic("eventTimestamps of type BACnetEventTimestampsEnclosed for BACnetEventSummary must not be nil")
	}
	if notifyType == nil {
		panic("notifyType of type BACnetNotifyTypeTagged for BACnetEventSummary must not be nil")
	}
	if eventEnable == nil {
		panic("eventEnable of type BACnetEventTransitionBitsTagged for BACnetEventSummary must not be nil")
	}
	if eventPriorities == nil {
		panic("eventPriorities of type BACnetEventPriorities for BACnetEventSummary must not be nil")
	}
	return &_BACnetEventSummary{ObjectIdentifier: objectIdentifier, EventState: eventState, AcknowledgedTransitions: acknowledgedTransitions, EventTimestamps: eventTimestamps, NotifyType: notifyType, EventEnable: eventEnable, EventPriorities: eventPriorities}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventSummaryBuilder is a builder for BACnetEventSummary
type BACnetEventSummaryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged, eventTimestamps BACnetEventTimestampsEnclosed, notifyType BACnetNotifyTypeTagged, eventEnable BACnetEventTransitionBitsTagged, eventPriorities BACnetEventPriorities) BACnetEventSummaryBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetEventSummaryBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetEventSummaryBuilder
	// WithEventState adds EventState (property field)
	WithEventState(BACnetEventStateTagged) BACnetEventSummaryBuilder
	// WithEventStateBuilder adds EventState (property field) which is build by the builder
	WithEventStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetEventSummaryBuilder
	// WithAcknowledgedTransitions adds AcknowledgedTransitions (property field)
	WithAcknowledgedTransitions(BACnetEventTransitionBitsTagged) BACnetEventSummaryBuilder
	// WithAcknowledgedTransitionsBuilder adds AcknowledgedTransitions (property field) which is build by the builder
	WithAcknowledgedTransitionsBuilder(func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetEventSummaryBuilder
	// WithEventTimestamps adds EventTimestamps (property field)
	WithEventTimestamps(BACnetEventTimestampsEnclosed) BACnetEventSummaryBuilder
	// WithEventTimestampsBuilder adds EventTimestamps (property field) which is build by the builder
	WithEventTimestampsBuilder(func(BACnetEventTimestampsEnclosedBuilder) BACnetEventTimestampsEnclosedBuilder) BACnetEventSummaryBuilder
	// WithNotifyType adds NotifyType (property field)
	WithNotifyType(BACnetNotifyTypeTagged) BACnetEventSummaryBuilder
	// WithNotifyTypeBuilder adds NotifyType (property field) which is build by the builder
	WithNotifyTypeBuilder(func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetEventSummaryBuilder
	// WithEventEnable adds EventEnable (property field)
	WithEventEnable(BACnetEventTransitionBitsTagged) BACnetEventSummaryBuilder
	// WithEventEnableBuilder adds EventEnable (property field) which is build by the builder
	WithEventEnableBuilder(func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetEventSummaryBuilder
	// WithEventPriorities adds EventPriorities (property field)
	WithEventPriorities(BACnetEventPriorities) BACnetEventSummaryBuilder
	// WithEventPrioritiesBuilder adds EventPriorities (property field) which is build by the builder
	WithEventPrioritiesBuilder(func(BACnetEventPrioritiesBuilder) BACnetEventPrioritiesBuilder) BACnetEventSummaryBuilder
	// Build builds the BACnetEventSummary or returns an error if something is wrong
	Build() (BACnetEventSummary, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventSummary
}

// NewBACnetEventSummaryBuilder() creates a BACnetEventSummaryBuilder
func NewBACnetEventSummaryBuilder() BACnetEventSummaryBuilder {
	return &_BACnetEventSummaryBuilder{_BACnetEventSummary: new(_BACnetEventSummary)}
}

type _BACnetEventSummaryBuilder struct {
	*_BACnetEventSummary

	collectedErr []error
}

var _ (BACnetEventSummaryBuilder) = (*_BACnetEventSummaryBuilder)(nil)

func (b *_BACnetEventSummaryBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged, eventTimestamps BACnetEventTimestampsEnclosed, notifyType BACnetNotifyTypeTagged, eventEnable BACnetEventTransitionBitsTagged, eventPriorities BACnetEventPriorities) BACnetEventSummaryBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithEventState(eventState).WithAcknowledgedTransitions(acknowledgedTransitions).WithEventTimestamps(eventTimestamps).WithNotifyType(notifyType).WithEventEnable(eventEnable).WithEventPriorities(eventPriorities)
}

func (b *_BACnetEventSummaryBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetEventSummaryBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetEventSummaryBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventState(eventState BACnetEventStateTagged) BACnetEventSummaryBuilder {
	b.EventState = eventState
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.EventState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.EventState, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithAcknowledgedTransitions(acknowledgedTransitions BACnetEventTransitionBitsTagged) BACnetEventSummaryBuilder {
	b.AcknowledgedTransitions = acknowledgedTransitions
	return b
}

func (b *_BACnetEventSummaryBuilder) WithAcknowledgedTransitionsBuilder(builderSupplier func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.AcknowledgedTransitions.CreateBACnetEventTransitionBitsTaggedBuilder())
	var err error
	b.AcknowledgedTransitions, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTransitionBitsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventTimestamps(eventTimestamps BACnetEventTimestampsEnclosed) BACnetEventSummaryBuilder {
	b.EventTimestamps = eventTimestamps
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventTimestampsBuilder(builderSupplier func(BACnetEventTimestampsEnclosedBuilder) BACnetEventTimestampsEnclosedBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.EventTimestamps.CreateBACnetEventTimestampsEnclosedBuilder())
	var err error
	b.EventTimestamps, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTimestampsEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithNotifyType(notifyType BACnetNotifyTypeTagged) BACnetEventSummaryBuilder {
	b.NotifyType = notifyType
	return b
}

func (b *_BACnetEventSummaryBuilder) WithNotifyTypeBuilder(builderSupplier func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.NotifyType.CreateBACnetNotifyTypeTaggedBuilder())
	var err error
	b.NotifyType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetNotifyTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventEnable(eventEnable BACnetEventTransitionBitsTagged) BACnetEventSummaryBuilder {
	b.EventEnable = eventEnable
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventEnableBuilder(builderSupplier func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.EventEnable.CreateBACnetEventTransitionBitsTaggedBuilder())
	var err error
	b.EventEnable, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTransitionBitsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventPriorities(eventPriorities BACnetEventPriorities) BACnetEventSummaryBuilder {
	b.EventPriorities = eventPriorities
	return b
}

func (b *_BACnetEventSummaryBuilder) WithEventPrioritiesBuilder(builderSupplier func(BACnetEventPrioritiesBuilder) BACnetEventPrioritiesBuilder) BACnetEventSummaryBuilder {
	builder := builderSupplier(b.EventPriorities.CreateBACnetEventPrioritiesBuilder())
	var err error
	b.EventPriorities, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventPrioritiesBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummaryBuilder) Build() (BACnetEventSummary, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.EventState == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventState' not set"))
	}
	if b.AcknowledgedTransitions == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'acknowledgedTransitions' not set"))
	}
	if b.EventTimestamps == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventTimestamps' not set"))
	}
	if b.NotifyType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'notifyType' not set"))
	}
	if b.EventEnable == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventEnable' not set"))
	}
	if b.EventPriorities == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventPriorities' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventSummary.deepCopy(), nil
}

func (b *_BACnetEventSummaryBuilder) MustBuild() BACnetEventSummary {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventSummaryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventSummaryBuilder().(*_BACnetEventSummaryBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventSummaryBuilder creates a BACnetEventSummaryBuilder
func (b *_BACnetEventSummary) CreateBACnetEventSummaryBuilder() BACnetEventSummaryBuilder {
	if b == nil {
		return NewBACnetEventSummaryBuilder()
	}
	return &_BACnetEventSummaryBuilder{_BACnetEventSummary: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventSummary) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetEventSummary) GetEventState() BACnetEventStateTagged {
	return m.EventState
}

func (m *_BACnetEventSummary) GetAcknowledgedTransitions() BACnetEventTransitionBitsTagged {
	return m.AcknowledgedTransitions
}

func (m *_BACnetEventSummary) GetEventTimestamps() BACnetEventTimestampsEnclosed {
	return m.EventTimestamps
}

func (m *_BACnetEventSummary) GetNotifyType() BACnetNotifyTypeTagged {
	return m.NotifyType
}

func (m *_BACnetEventSummary) GetEventEnable() BACnetEventTransitionBitsTagged {
	return m.EventEnable
}

func (m *_BACnetEventSummary) GetEventPriorities() BACnetEventPriorities {
	return m.EventPriorities
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventSummary(structType any) BACnetEventSummary {
	if casted, ok := structType.(BACnetEventSummary); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventSummary); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventSummary) GetTypeName() string {
	return "BACnetEventSummary"
}

func (m *_BACnetEventSummary) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (eventState)
	lengthInBits += m.EventState.GetLengthInBits(ctx)

	// Simple field (acknowledgedTransitions)
	lengthInBits += m.AcknowledgedTransitions.GetLengthInBits(ctx)

	// Simple field (eventTimestamps)
	lengthInBits += m.EventTimestamps.GetLengthInBits(ctx)

	// Simple field (notifyType)
	lengthInBits += m.NotifyType.GetLengthInBits(ctx)

	// Simple field (eventEnable)
	lengthInBits += m.EventEnable.GetLengthInBits(ctx)

	// Simple field (eventPriorities)
	lengthInBits += m.EventPriorities.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventSummary) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventSummaryParse(ctx context.Context, theBytes []byte) (BACnetEventSummary, error) {
	return BACnetEventSummaryParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetEventSummaryParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventSummary, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventSummary, error) {
		return BACnetEventSummaryParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetEventSummaryParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventSummary, error) {
	v, err := (&_BACnetEventSummary{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventSummary) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetEventSummary BACnetEventSummary, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventSummary"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventSummary")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	eventState, err := ReadSimpleField[BACnetEventStateTagged](ctx, "eventState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventState' field"))
	}
	m.EventState = eventState

	acknowledgedTransitions, err := ReadSimpleField[BACnetEventTransitionBitsTagged](ctx, "acknowledgedTransitions", ReadComplex[BACnetEventTransitionBitsTagged](BACnetEventTransitionBitsTaggedParseWithBufferProducer((uint8)(uint8(2)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'acknowledgedTransitions' field"))
	}
	m.AcknowledgedTransitions = acknowledgedTransitions

	eventTimestamps, err := ReadSimpleField[BACnetEventTimestampsEnclosed](ctx, "eventTimestamps", ReadComplex[BACnetEventTimestampsEnclosed](BACnetEventTimestampsEnclosedParseWithBufferProducer((uint8)(uint8(3))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventTimestamps' field"))
	}
	m.EventTimestamps = eventTimestamps

	notifyType, err := ReadSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", ReadComplex[BACnetNotifyTypeTagged](BACnetNotifyTypeTaggedParseWithBufferProducer((uint8)(uint8(4)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notifyType' field"))
	}
	m.NotifyType = notifyType

	eventEnable, err := ReadSimpleField[BACnetEventTransitionBitsTagged](ctx, "eventEnable", ReadComplex[BACnetEventTransitionBitsTagged](BACnetEventTransitionBitsTaggedParseWithBufferProducer((uint8)(uint8(5)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventEnable' field"))
	}
	m.EventEnable = eventEnable

	eventPriorities, err := ReadSimpleField[BACnetEventPriorities](ctx, "eventPriorities", ReadComplex[BACnetEventPriorities](BACnetEventPrioritiesParseWithBufferProducer((uint8)(uint8(6))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventPriorities' field"))
	}
	m.EventPriorities = eventPriorities

	if closeErr := readBuffer.CloseContext("BACnetEventSummary"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventSummary")
	}

	return m, nil
}

func (m *_BACnetEventSummary) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventSummary) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventSummary"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventSummary")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteSimpleField[BACnetEventStateTagged](ctx, "eventState", m.GetEventState(), WriteComplex[BACnetEventStateTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventState' field")
	}

	if err := WriteSimpleField[BACnetEventTransitionBitsTagged](ctx, "acknowledgedTransitions", m.GetAcknowledgedTransitions(), WriteComplex[BACnetEventTransitionBitsTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'acknowledgedTransitions' field")
	}

	if err := WriteSimpleField[BACnetEventTimestampsEnclosed](ctx, "eventTimestamps", m.GetEventTimestamps(), WriteComplex[BACnetEventTimestampsEnclosed](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventTimestamps' field")
	}

	if err := WriteSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", m.GetNotifyType(), WriteComplex[BACnetNotifyTypeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'notifyType' field")
	}

	if err := WriteSimpleField[BACnetEventTransitionBitsTagged](ctx, "eventEnable", m.GetEventEnable(), WriteComplex[BACnetEventTransitionBitsTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventEnable' field")
	}

	if err := WriteSimpleField[BACnetEventPriorities](ctx, "eventPriorities", m.GetEventPriorities(), WriteComplex[BACnetEventPriorities](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventPriorities' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventSummary"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventSummary")
	}
	return nil
}

func (m *_BACnetEventSummary) IsBACnetEventSummary() {}

func (m *_BACnetEventSummary) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventSummary) deepCopy() *_BACnetEventSummary {
	if m == nil {
		return nil
	}
	_BACnetEventSummaryCopy := &_BACnetEventSummary{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetEventStateTagged](m.EventState),
		utils.DeepCopy[BACnetEventTransitionBitsTagged](m.AcknowledgedTransitions),
		utils.DeepCopy[BACnetEventTimestampsEnclosed](m.EventTimestamps),
		utils.DeepCopy[BACnetNotifyTypeTagged](m.NotifyType),
		utils.DeepCopy[BACnetEventTransitionBitsTagged](m.EventEnable),
		utils.DeepCopy[BACnetEventPriorities](m.EventPriorities),
	}
	return _BACnetEventSummaryCopy
}

func (m *_BACnetEventSummary) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
