/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishedDataSetSourceDataType is the corresponding interface of PublishedDataSetSourceDataType
type PublishedDataSetSourceDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsPublishedDataSetSourceDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishedDataSetSourceDataType()
	// CreateBuilder creates a PublishedDataSetSourceDataTypeBuilder
	CreatePublishedDataSetSourceDataTypeBuilder() PublishedDataSetSourceDataTypeBuilder
}

// _PublishedDataSetSourceDataType is the data-structure of this message
type _PublishedDataSetSourceDataType struct {
	ExtensionObjectDefinitionContract
}

var _ PublishedDataSetSourceDataType = (*_PublishedDataSetSourceDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishedDataSetSourceDataType)(nil)

// NewPublishedDataSetSourceDataType factory function for _PublishedDataSetSourceDataType
func NewPublishedDataSetSourceDataType() *_PublishedDataSetSourceDataType {
	_result := &_PublishedDataSetSourceDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishedDataSetSourceDataTypeBuilder is a builder for PublishedDataSetSourceDataType
type PublishedDataSetSourceDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() PublishedDataSetSourceDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishedDataSetSourceDataType or returns an error if something is wrong
	Build() (PublishedDataSetSourceDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishedDataSetSourceDataType
}

// NewPublishedDataSetSourceDataTypeBuilder() creates a PublishedDataSetSourceDataTypeBuilder
func NewPublishedDataSetSourceDataTypeBuilder() PublishedDataSetSourceDataTypeBuilder {
	return &_PublishedDataSetSourceDataTypeBuilder{_PublishedDataSetSourceDataType: new(_PublishedDataSetSourceDataType)}
}

type _PublishedDataSetSourceDataTypeBuilder struct {
	*_PublishedDataSetSourceDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (PublishedDataSetSourceDataTypeBuilder) = (*_PublishedDataSetSourceDataTypeBuilder)(nil)

func (b *_PublishedDataSetSourceDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishedDataSetSourceDataType
}

func (b *_PublishedDataSetSourceDataTypeBuilder) WithMandatoryFields() PublishedDataSetSourceDataTypeBuilder {
	return b
}

func (b *_PublishedDataSetSourceDataTypeBuilder) Build() (PublishedDataSetSourceDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._PublishedDataSetSourceDataType.deepCopy(), nil
}

func (b *_PublishedDataSetSourceDataTypeBuilder) MustBuild() PublishedDataSetSourceDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishedDataSetSourceDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishedDataSetSourceDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishedDataSetSourceDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePublishedDataSetSourceDataTypeBuilder().(*_PublishedDataSetSourceDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreatePublishedDataSetSourceDataTypeBuilder creates a PublishedDataSetSourceDataTypeBuilder
func (b *_PublishedDataSetSourceDataType) CreatePublishedDataSetSourceDataTypeBuilder() PublishedDataSetSourceDataTypeBuilder {
	if b == nil {
		return NewPublishedDataSetSourceDataTypeBuilder()
	}
	return &_PublishedDataSetSourceDataTypeBuilder{_PublishedDataSetSourceDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishedDataSetSourceDataType) GetExtensionId() int32 {
	return int32(15582)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishedDataSetSourceDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastPublishedDataSetSourceDataType(structType any) PublishedDataSetSourceDataType {
	if casted, ok := structType.(PublishedDataSetSourceDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PublishedDataSetSourceDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PublishedDataSetSourceDataType) GetTypeName() string {
	return "PublishedDataSetSourceDataType"
}

func (m *_PublishedDataSetSourceDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_PublishedDataSetSourceDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishedDataSetSourceDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishedDataSetSourceDataType PublishedDataSetSourceDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishedDataSetSourceDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishedDataSetSourceDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("PublishedDataSetSourceDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishedDataSetSourceDataType")
	}

	return m, nil
}

func (m *_PublishedDataSetSourceDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishedDataSetSourceDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishedDataSetSourceDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishedDataSetSourceDataType")
		}

		if popErr := writeBuffer.PopContext("PublishedDataSetSourceDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishedDataSetSourceDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishedDataSetSourceDataType) IsPublishedDataSetSourceDataType() {}

func (m *_PublishedDataSetSourceDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishedDataSetSourceDataType) deepCopy() *_PublishedDataSetSourceDataType {
	if m == nil {
		return nil
	}
	_PublishedDataSetSourceDataTypeCopy := &_PublishedDataSetSourceDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_PublishedDataSetSourceDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishedDataSetSourceDataTypeCopy
}

func (m *_PublishedDataSetSourceDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
