/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantLocalizedText is the corresponding interface of VariantLocalizedText
type VariantLocalizedText interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []LocalizedText
	// IsVariantLocalizedText is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantLocalizedText()
	// CreateBuilder creates a VariantLocalizedTextBuilder
	CreateVariantLocalizedTextBuilder() VariantLocalizedTextBuilder
}

// _VariantLocalizedText is the data-structure of this message
type _VariantLocalizedText struct {
	VariantContract
	ArrayLength *int32
	Value       []LocalizedText
}

var _ VariantLocalizedText = (*_VariantLocalizedText)(nil)
var _ VariantRequirements = (*_VariantLocalizedText)(nil)

// NewVariantLocalizedText factory function for _VariantLocalizedText
func NewVariantLocalizedText(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []LocalizedText) *_VariantLocalizedText {
	_result := &_VariantLocalizedText{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantLocalizedTextBuilder is a builder for VariantLocalizedText
type VariantLocalizedTextBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []LocalizedText) VariantLocalizedTextBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantLocalizedTextBuilder
	// WithValue adds Value (property field)
	WithValue(...LocalizedText) VariantLocalizedTextBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantLocalizedText or returns an error if something is wrong
	Build() (VariantLocalizedText, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantLocalizedText
}

// NewVariantLocalizedTextBuilder() creates a VariantLocalizedTextBuilder
func NewVariantLocalizedTextBuilder() VariantLocalizedTextBuilder {
	return &_VariantLocalizedTextBuilder{_VariantLocalizedText: new(_VariantLocalizedText)}
}

type _VariantLocalizedTextBuilder struct {
	*_VariantLocalizedText

	parentBuilder *_VariantBuilder

	collectedErr []error
}

var _ (VariantLocalizedTextBuilder) = (*_VariantLocalizedTextBuilder)(nil)

func (b *_VariantLocalizedTextBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantLocalizedText
}

func (b *_VariantLocalizedTextBuilder) WithMandatoryFields(value []LocalizedText) VariantLocalizedTextBuilder {
	return b.WithValue(value...)
}

func (b *_VariantLocalizedTextBuilder) WithOptionalArrayLength(arrayLength int32) VariantLocalizedTextBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantLocalizedTextBuilder) WithValue(value ...LocalizedText) VariantLocalizedTextBuilder {
	b.Value = value
	return b
}

func (b *_VariantLocalizedTextBuilder) Build() (VariantLocalizedText, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VariantLocalizedText.deepCopy(), nil
}

func (b *_VariantLocalizedTextBuilder) MustBuild() VariantLocalizedText {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantLocalizedTextBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantLocalizedTextBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantLocalizedTextBuilder) DeepCopy() any {
	_copy := b.CreateVariantLocalizedTextBuilder().(*_VariantLocalizedTextBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVariantLocalizedTextBuilder creates a VariantLocalizedTextBuilder
func (b *_VariantLocalizedText) CreateVariantLocalizedTextBuilder() VariantLocalizedTextBuilder {
	if b == nil {
		return NewVariantLocalizedTextBuilder()
	}
	return &_VariantLocalizedTextBuilder{_VariantLocalizedText: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantLocalizedText) GetVariantType() uint8 {
	return uint8(21)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantLocalizedText) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantLocalizedText) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantLocalizedText) GetValue() []LocalizedText {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantLocalizedText(structType any) VariantLocalizedText {
	if casted, ok := structType.(VariantLocalizedText); ok {
		return casted
	}
	if casted, ok := structType.(*VariantLocalizedText); ok {
		return *casted
	}
	return nil
}

func (m *_VariantLocalizedText) GetTypeName() string {
	return "VariantLocalizedText"
}

func (m *_VariantLocalizedText) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		for _curItem, element := range m.Value {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Value), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_VariantLocalizedText) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantLocalizedText) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantLocalizedText VariantLocalizedText, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantLocalizedText"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantLocalizedText")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[LocalizedText](ctx, "value", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantLocalizedText"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantLocalizedText")
	}

	return m, nil
}

func (m *_VariantLocalizedText) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantLocalizedText) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantLocalizedText"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantLocalizedText")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "value", m.GetValue(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantLocalizedText"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantLocalizedText")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantLocalizedText) IsVariantLocalizedText() {}

func (m *_VariantLocalizedText) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantLocalizedText) deepCopy() *_VariantLocalizedText {
	if m == nil {
		return nil
	}
	_VariantLocalizedTextCopy := &_VariantLocalizedText{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[LocalizedText, LocalizedText](m.Value),
	}
	_VariantLocalizedTextCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantLocalizedTextCopy
}

func (m *_VariantLocalizedText) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
