/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum MediaTransportControlCommandType {
  STOP((byte) 0x00, (short) 0),
  PLAY((byte) 0x01, (short) 0),
  PAUSE_RESUME((byte) 0x02, (short) 1),
  SELECT_CATEGORY((byte) 0x03, (short) 1),
  SELECT_SELECTION((byte) 0x04, (short) 2),
  SELECT_TRACK((byte) 0x05, (short) 4),
  SHUFFLE_ON_OFF((byte) 0x06, (short) 1),
  REPEAT_ON_OFF((byte) 0x07, (short) 1),
  NEXT_PREVIOUS_CATEGORY((byte) 0x08, (short) 1),
  NEXT_PREVIOUS_SELECTION((byte) 0x09, (short) 1),
  NEXT_PREVIOUS_TRACK((byte) 0x09, (short) 1),
  FAST_FORWARD((byte) 0x09, (short) 1),
  REWIND((byte) 0x09, (short) 1),
  SOURCE_POWER_CONTROL((byte) 0x09, (short) 1),
  TOTAL_TRACKS((byte) 0x09, (short) 4),
  STATUS_REQUEST((byte) 0x09, (short) 0),
  ENUMERATE_CATEGORIES_SELECTIONS_TRACKS((byte) 0x09, (short) 2),
  ENUMERATION_SIZE((byte) 0x0A, (short) 3),
  TRACK_NAME((byte) 0x0B, (short) 1),
  SELECTION_NAME((byte) 0x0C, (short) 1),
  CATEGORY_NAME((byte) 0x0D, (short) 1);
  private static final Map<Byte, MediaTransportControlCommandType> map;

  static {
    map = new HashMap<>();
    for (MediaTransportControlCommandType value : MediaTransportControlCommandType.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final short numberOfArguments;

  MediaTransportControlCommandType(byte value, short numberOfArguments) {
    this.value = value;
    this.numberOfArguments = numberOfArguments;
  }

  public byte getValue() {
    return value;
  }

  public short getNumberOfArguments() {
    return numberOfArguments;
  }

  public static MediaTransportControlCommandType firstEnumForFieldNumberOfArguments(
      short fieldValue) {
    for (MediaTransportControlCommandType _val : MediaTransportControlCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<MediaTransportControlCommandType> enumsForFieldNumberOfArguments(
      short fieldValue) {
    List<MediaTransportControlCommandType> _values = new ArrayList<>();
    for (MediaTransportControlCommandType _val : MediaTransportControlCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static MediaTransportControlCommandType enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
