/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReplyEncodedReply extends Reply implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final EncodedReply encodedReply;
  protected final Checksum chksum;

  // Arguments.
  protected final CBusOptions cBusOptions;
  protected final RequestContext requestContext;

  public ReplyEncodedReply(
      byte peekedByte,
      EncodedReply encodedReply,
      Checksum chksum,
      CBusOptions cBusOptions,
      RequestContext requestContext) {
    super(peekedByte, cBusOptions, requestContext);
    this.encodedReply = encodedReply;
    this.chksum = chksum;
    this.cBusOptions = cBusOptions;
    this.requestContext = requestContext;
  }

  public EncodedReply getEncodedReply() {
    return encodedReply;
  }

  public Checksum getChksum() {
    return chksum;
  }

  public EncodedReply getEncodedReplyDecoded() {
    return (EncodedReply) (getEncodedReply());
  }

  public Checksum getChksumDecoded() {
    return (Checksum) (getChksum());
  }

  @Override
  protected void serializeReplyChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReplyEncodedReply");

    // Manual Field (encodedReply)
    writeManualField(
        "encodedReply",
        () ->
            org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper.writeEncodedReply(
                writeBuffer, encodedReply),
        writeBuffer);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    EncodedReply encodedReplyDecoded = getEncodedReplyDecoded();
    writeBuffer.writeVirtual("encodedReplyDecoded", encodedReplyDecoded);

    // Manual Field (chksum)
    writeManualField(
        "chksum",
        () ->
            org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper.calculateChecksum(
                writeBuffer, encodedReply, cBusOptions.getSrchk()),
        writeBuffer);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    Checksum chksumDecoded = getChksumDecoded();
    writeBuffer.writeVirtual("chksumDecoded", chksumDecoded);

    writeBuffer.popContext("ReplyEncodedReply");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReplyEncodedReply _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Manual Field (encodedReply)
    lengthInBits += (((encodedReply.getLengthInBytes()) * (2))) * (8);

    // A virtual field doesn't have any in- or output.

    // Manual Field (chksum)
    lengthInBits += (((cBusOptions.getSrchk())) ? (16) : (0));

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static ReplyBuilder staticParseReplyBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions, RequestContext requestContext)
      throws ParseException {
    readBuffer.pullContext("ReplyEncodedReply");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    EncodedReply encodedReply =
        readManualField(
            "encodedReply",
            readBuffer,
            () ->
                (EncodedReply)
                    (org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper.readEncodedReply(
                        readBuffer, cBusOptions, requestContext, cBusOptions.getSrchk())));
    EncodedReply encodedReplyDecoded =
        readVirtualField("encodedReplyDecoded", EncodedReply.class, encodedReply);

    Checksum chksum =
        readManualField(
            "chksum",
            readBuffer,
            () ->
                (Checksum)
                    (org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper
                        .readAndValidateChecksum(
                            readBuffer, encodedReply, cBusOptions.getSrchk())));
    Checksum chksumDecoded = readVirtualField("chksumDecoded", Checksum.class, chksum);

    readBuffer.closeContext("ReplyEncodedReply");
    // Create the instance
    return new ReplyEncodedReplyBuilderImpl(encodedReply, chksum, cBusOptions, requestContext);
  }

  public static class ReplyEncodedReplyBuilderImpl implements Reply.ReplyBuilder {
    private final EncodedReply encodedReply;
    private final Checksum chksum;
    private final CBusOptions cBusOptions;
    private final RequestContext requestContext;

    public ReplyEncodedReplyBuilderImpl(
        EncodedReply encodedReply,
        Checksum chksum,
        CBusOptions cBusOptions,
        RequestContext requestContext) {
      this.encodedReply = encodedReply;
      this.chksum = chksum;
      this.cBusOptions = cBusOptions;
      this.requestContext = requestContext;
    }

    public ReplyEncodedReply build(
        byte peekedByte, CBusOptions cBusOptions, RequestContext requestContext) {
      ReplyEncodedReply replyEncodedReply =
          new ReplyEncodedReply(peekedByte, encodedReply, chksum, cBusOptions, requestContext);
      return replyEncodedReply;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReplyEncodedReply)) {
      return false;
    }
    ReplyEncodedReply that = (ReplyEncodedReply) o;
    return (getEncodedReply() == that.getEncodedReply())
        && (getChksum() == that.getChksum())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getEncodedReply(), getChksum());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
