/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum TelephonyCommandTypeContainer {
  TelephonyCommandLineOnHook((short) 0x09, (byte) 1, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_0Bytes((short) 0xA0, (byte) 0, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_1Bytes((short) 0xA1, (byte) 1, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_2Bytes((short) 0xA2, (byte) 2, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_3Bytes((short) 0xA3, (byte) 3, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_4Bytes((short) 0xA4, (byte) 4, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_5Bytes((short) 0xA5, (byte) 5, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_6Bytes((short) 0xA6, (byte) 6, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_7Bytes((short) 0xA7, (byte) 7, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_8Bytes((short) 0xA8, (byte) 8, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_9Bytes((short) 0xA9, (byte) 9, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_10Bytes((short) 0xAA, (byte) 10, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_11Bytes((short) 0xAB, (byte) 11, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_12Bytes((short) 0xAC, (byte) 12, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_13Bytes((short) 0xAD, (byte) 13, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_14Bytes((short) 0xAE, (byte) 14, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_15Bytes((short) 0xAF, (byte) 15, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_16Bytes((short) 0xB0, (byte) 16, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_17Bytes((short) 0xB1, (byte) 17, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_18Bytes((short) 0xB2, (byte) 18, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_19Bytes((short) 0xB3, (byte) 19, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_20Bytes((short) 0xB4, (byte) 20, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_21Bytes((short) 0xB5, (byte) 21, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_22Bytes((short) 0xB6, (byte) 22, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_23Bytes((short) 0xB7, (byte) 23, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_24Bytes((short) 0xB8, (byte) 24, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_25Bytes((short) 0xB9, (byte) 25, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_26Bytes((short) 0xBA, (byte) 26, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_27Bytes((short) 0xBB, (byte) 27, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_28Bytes((short) 0xBC, (byte) 28, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_29Bytes((short) 0xBD, (byte) 29, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_30Bytes((short) 0xBE, (byte) 30, TelephonyCommandType.EVENT),
  TelephonyCommandLineOffHook_31Bytes((short) 0xBF, (byte) 31, TelephonyCommandType.EVENT);
  private static final Map<Short, TelephonyCommandTypeContainer> map;

  static {
    map = new HashMap<>();
    for (TelephonyCommandTypeContainer value : TelephonyCommandTypeContainer.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final byte numBytes;
  private final TelephonyCommandType commandType;

  TelephonyCommandTypeContainer(short value, byte numBytes, TelephonyCommandType commandType) {
    this.value = value;
    this.numBytes = numBytes;
    this.commandType = commandType;
  }

  public short getValue() {
    return value;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public static TelephonyCommandTypeContainer firstEnumForFieldNumBytes(byte fieldValue) {
    for (TelephonyCommandTypeContainer _val : TelephonyCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<TelephonyCommandTypeContainer> enumsForFieldNumBytes(byte fieldValue) {
    List<TelephonyCommandTypeContainer> _values = new ArrayList<>();
    for (TelephonyCommandTypeContainer _val : TelephonyCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public TelephonyCommandType getCommandType() {
    return commandType;
  }

  public static TelephonyCommandTypeContainer firstEnumForFieldCommandType(
      TelephonyCommandType fieldValue) {
    for (TelephonyCommandTypeContainer _val : TelephonyCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<TelephonyCommandTypeContainer> enumsForFieldCommandType(
      TelephonyCommandType fieldValue) {
    List<TelephonyCommandTypeContainer> _values = new ArrayList<>();
    for (TelephonyCommandTypeContainer _val : TelephonyCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static TelephonyCommandTypeContainer enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
