/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DeleteMonitoredItemsRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 781;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final long subscriptionId;
  protected final List<Long> monitoredItemIds;

  public DeleteMonitoredItemsRequest(
      RequestHeader requestHeader, long subscriptionId, List<Long> monitoredItemIds) {
    super();
    this.requestHeader = requestHeader;
    this.subscriptionId = subscriptionId;
    this.monitoredItemIds = monitoredItemIds;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public long getSubscriptionId() {
    return subscriptionId;
  }

  public List<Long> getMonitoredItemIds() {
    return monitoredItemIds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DeleteMonitoredItemsRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Simple Field (subscriptionId)
    writeSimpleField("subscriptionId", subscriptionId, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfMonitoredItemIds) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfMonitoredItemIds =
        (int) ((((getMonitoredItemIds()) == (null)) ? -(1) : COUNT(getMonitoredItemIds())));
    writeImplicitField(
        "noOfMonitoredItemIds", noOfMonitoredItemIds, writeSignedInt(writeBuffer, 32));

    // Array Field (monitoredItemIds)
    writeSimpleTypeArrayField(
        "monitoredItemIds", monitoredItemIds, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("DeleteMonitoredItemsRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DeleteMonitoredItemsRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (subscriptionId)
    lengthInBits += 32;

    // Implicit Field (noOfMonitoredItemIds)
    lengthInBits += 32;

    // Array field
    if (monitoredItemIds != null) {
      lengthInBits += 32 * monitoredItemIds.size();
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DeleteMonitoredItemsRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    long subscriptionId = readSimpleField("subscriptionId", readUnsignedLong(readBuffer, 32));

    int noOfMonitoredItemIds =
        readImplicitField("noOfMonitoredItemIds", readSignedInt(readBuffer, 32));

    List<Long> monitoredItemIds =
        readCountArrayField(
            "monitoredItemIds", readUnsignedLong(readBuffer, 32), noOfMonitoredItemIds);

    readBuffer.closeContext("DeleteMonitoredItemsRequest");
    // Create the instance
    return new DeleteMonitoredItemsRequestBuilderImpl(
        requestHeader, subscriptionId, monitoredItemIds);
  }

  public static class DeleteMonitoredItemsRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final long subscriptionId;
    private final List<Long> monitoredItemIds;

    public DeleteMonitoredItemsRequestBuilderImpl(
        RequestHeader requestHeader, long subscriptionId, List<Long> monitoredItemIds) {
      this.requestHeader = requestHeader;
      this.subscriptionId = subscriptionId;
      this.monitoredItemIds = monitoredItemIds;
    }

    public DeleteMonitoredItemsRequest build() {
      DeleteMonitoredItemsRequest deleteMonitoredItemsRequest =
          new DeleteMonitoredItemsRequest(requestHeader, subscriptionId, monitoredItemIds);
      return deleteMonitoredItemsRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DeleteMonitoredItemsRequest)) {
      return false;
    }
    DeleteMonitoredItemsRequest that = (DeleteMonitoredItemsRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getSubscriptionId() == that.getSubscriptionId())
        && (getMonitoredItemIds() == that.getMonitoredItemIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getRequestHeader(), getSubscriptionId(), getMonitoredItemIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
