/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesObjectType {
  BaseObjectType((int) 58L),
  FolderType((int) 61L),
  DataTypeSystemType((int) 75L),
  DataTypeEncodingType((int) 76L),
  ModellingRuleType((int) 77L),
  ServerType((int) 2004L),
  ServerCapabilitiesType((int) 2013L),
  ServerDiagnosticsType((int) 2020L),
  SessionsDiagnosticsSummaryType((int) 2026L),
  SessionDiagnosticsObjectType((int) 2029L),
  VendorServerInfoType((int) 2033L),
  ServerRedundancyType((int) 2034L),
  TransparentRedundancyType((int) 2036L),
  NonTransparentRedundancyType((int) 2039L),
  BaseEventType((int) 2041L),
  AuditEventType((int) 2052L),
  AuditSecurityEventType((int) 2058L),
  AuditChannelEventType((int) 2059L),
  AuditOpenSecureChannelEventType((int) 2060L),
  AuditSessionEventType((int) 2069L),
  AuditCreateSessionEventType((int) 2071L),
  AuditActivateSessionEventType((int) 2075L),
  AuditCancelEventType((int) 2078L),
  AuditCertificateEventType((int) 2080L),
  AuditCertificateDataMismatchEventType((int) 2082L),
  AuditCertificateExpiredEventType((int) 2085L),
  AuditCertificateInvalidEventType((int) 2086L),
  AuditCertificateUntrustedEventType((int) 2087L),
  AuditCertificateRevokedEventType((int) 2088L),
  AuditCertificateMismatchEventType((int) 2089L),
  AuditNodeManagementEventType((int) 2090L),
  AuditAddNodesEventType((int) 2091L),
  AuditDeleteNodesEventType((int) 2093L),
  AuditAddReferencesEventType((int) 2095L),
  AuditDeleteReferencesEventType((int) 2097L),
  AuditUpdateEventType((int) 2099L),
  AuditWriteUpdateEventType((int) 2100L),
  AuditHistoryUpdateEventType((int) 2104L),
  AuditUpdateMethodEventType((int) 2127L),
  SystemEventType((int) 2130L),
  DeviceFailureEventType((int) 2131L),
  BaseModelChangeEventType((int) 2132L),
  GeneralModelChangeEventType((int) 2133L),
  StateMachineType((int) 2299L),
  StateType((int) 2307L),
  InitialStateType((int) 2309L),
  TransitionType((int) 2310L),
  TransitionEventType((int) 2311L),
  AuditUpdateStateEventType((int) 2315L),
  HistoricalDataConfigurationType((int) 2318L),
  HistoryServerCapabilitiesType((int) 2330L),
  AggregateFunctionType((int) 2340L),
  ProgramTransitionEventType((int) 2378L),
  ProgramStateMachineType((int) 2391L),
  SemanticChangeEventType((int) 2738L),
  AuditUrlMismatchEventType((int) 2748L),
  FiniteStateMachineType((int) 2771L),
  ConditionType((int) 2782L),
  RefreshStartEventType((int) 2787L),
  RefreshEndEventType((int) 2788L),
  RefreshRequiredEventType((int) 2789L),
  AuditConditionEventType((int) 2790L),
  AuditConditionEnableEventType((int) 2803L),
  AuditConditionCommentEventType((int) 2829L),
  DialogConditionType((int) 2830L),
  AcknowledgeableConditionType((int) 2881L),
  AlarmConditionType((int) 2915L),
  ShelvedStateMachineType((int) 2929L),
  LimitAlarmType((int) 2955L),
  AuditHistoryEventUpdateEventType((int) 2999L),
  AuditHistoryValueUpdateEventType((int) 3006L),
  AuditHistoryDeleteEventType((int) 3012L),
  AuditHistoryRawModifyDeleteEventType((int) 3014L),
  AuditHistoryAtTimeDeleteEventType((int) 3019L),
  AuditHistoryEventDeleteEventType((int) 3022L),
  EventQueueOverflowEventType((int) 3035L),
  ProgramTransitionAuditEventType((int) 3806L),
  AuditConditionRespondEventType((int) 8927L),
  AuditConditionAcknowledgeEventType((int) 8944L),
  AuditConditionConfirmEventType((int) 8961L),
  ExclusiveLimitStateMachineType((int) 9318L),
  ExclusiveLimitAlarmType((int) 9341L),
  ExclusiveLevelAlarmType((int) 9482L),
  ExclusiveRateOfChangeAlarmType((int) 9623L),
  ExclusiveDeviationAlarmType((int) 9764L),
  NonExclusiveLimitAlarmType((int) 9906L),
  NonExclusiveLevelAlarmType((int) 10060L),
  NonExclusiveRateOfChangeAlarmType((int) 10214L),
  NonExclusiveDeviationAlarmType((int) 10368L),
  DiscreteAlarmType((int) 10523L),
  OffNormalAlarmType((int) 10637L),
  TripAlarmType((int) 10751L),
  AuditConditionShelvingEventType((int) 11093L),
  BaseConditionClassType((int) 11163L),
  ProcessConditionClassType((int) 11164L),
  MaintenanceConditionClassType((int) 11165L),
  SystemConditionClassType((int) 11166L),
  AggregateConfigurationType((int) 11187L),
  ProgressEventType((int) 11436L),
  SystemStatusChangeEventType((int) 11446L),
  OperationLimitsType((int) 11564L),
  FileType((int) 11575L),
  AddressSpaceFileType((int) 11595L),
  NamespaceMetadataType((int) 11616L),
  NamespacesType((int) 11645L),
  SystemOffNormalAlarmType((int) 11753L),
  AuditProgramTransitionEventType((int) 11856L),
  NonTransparentNetworkRedundancyType((int) 11945L),
  TrustListType((int) 12522L),
  CertificateGroupType((int) 12555L),
  CertificateType((int) 12556L),
  ApplicationCertificateType((int) 12557L),
  HttpsCertificateType((int) 12558L),
  RsaMinApplicationCertificateType((int) 12559L),
  RsaSha256ApplicationCertificateType((int) 12560L),
  TrustListUpdatedAuditEventType((int) 12561L),
  ServerConfigurationType((int) 12581L),
  CertificateUpdatedAuditEventType((int) 12620L),
  CertificateExpirationAlarmType((int) 13225L),
  FileDirectoryType((int) 13353L),
  CertificateGroupFolderType((int) 13813L),
  PubSubConnectionType((int) 14209L),
  PubSubGroupType((int) 14232L),
  PublishSubscribeType((int) 14416L),
  DataSetFolderType((int) 14477L),
  PublishedDataSetType((int) 14509L),
  PublishedDataItemsType((int) 14534L),
  PublishedEventsType((int) 14572L),
  PubSubStatusType((int) 14643L),
  AuditConditionResetEventType((int) 15013L),
  DatagramConnectionTransportType((int) 15064L),
  SubscribedDataSetType((int) 15108L),
  ChoiceStateType((int) 15109L),
  TargetVariablesType((int) 15111L),
  SubscribedDataSetMirrorType((int) 15127L),
  BrokerConnectionTransportType((int) 15155L),
  UserCredentialCertificateType((int) 15181L),
  DataSetWriterType((int) 15298L),
  DataSetWriterTransportType((int) 15305L),
  DataSetReaderType((int) 15306L),
  DataSetReaderTransportType((int) 15319L),
  ConfigurationFileType((int) 15437L),
  SecurityGroupFolderType((int) 15452L),
  SecurityGroupType((int) 15471L),
  ExtensionFieldsType((int) 15489L),
  PubSubStatusEventType((int) 15535L),
  ConfigurationUpdatedAuditEventType((int) 15541L),
  PubSubTransportLimitsExceedEventType((int) 15548L),
  ApplicationConfigurationFileType((int) 15550L),
  PubSubCommunicationFailureEventType((int) 15563L),
  RoleSetType((int) 15607L),
  RoleType((int) 15620L),
  TemporaryFileTransferType((int) 15744L),
  FileTransferStateMachineType((int) 15803L),
  PubSubKeyServiceType((int) 15906L),
  AlarmGroupType((int) 16405L),
  ApplicationConfigurationFolderType((int) 16662L),
  DiscrepancyAlarmType((int) 17080L),
  SafetyConditionClassType((int) 17218L),
  HighlyManagedAlarmConditionClassType((int) 17219L),
  TrainingConditionClassType((int) 17220L),
  TestingConditionClassType((int) 17221L),
  AuditConditionSuppressionEventType((int) 17225L),
  AuditConditionSilenceEventType((int) 17242L),
  AuditConditionOutOfServiceEventType((int) 17259L),
  AlarmMetricsType((int) 17279L),
  KeyCredentialConfigurationFolderType((int) 17496L),
  DictionaryEntryType((int) 17589L),
  DictionaryFolderType((int) 17591L),
  IrdiDictionaryEntryType((int) 17598L),
  UriDictionaryEntryType((int) 17600L),
  BaseInterfaceType((int) 17602L),
  RoleMappingRuleChangedAuditEventType((int) 17641L),
  ConnectionTransportType((int) 17721L),
  WriterGroupType((int) 17725L),
  AuthorizationServiceConfigurationType((int) 17852L),
  WriterGroupTransportType((int) 17997L),
  WriterGroupMessageType((int) 17998L),
  ReaderGroupType((int) 17999L),
  KeyCredentialConfigurationType((int) 18001L),
  KeyCredentialAuditEventType((int) 18011L),
  KeyCredentialUpdatedAuditEventType((int) 18029L),
  KeyCredentialDeletedAuditEventType((int) 18047L),
  InstrumentDiagnosticAlarmType((int) 18347L),
  SystemDiagnosticAlarmType((int) 18496L),
  StatisticalConditionClassType((int) 18665L),
  LldpInformationType((int) 18973L),
  LldpRemoteStatisticsType((int) 18996L),
  LldpLocalSystemType((int) 19002L),
  LldpPortInformationType((int) 19009L),
  LldpRemoteSystemType((int) 19033L),
  AuditHistoryAnnotationUpdateEventType((int) 19095L),
  TrustListOutOfDateAlarmType((int) 19297L),
  UserCertificateType((int) 19323L),
  TlsCertificateType((int) 19324L),
  TlsServerCertificateType((int) 19325L),
  TlsClientCertificateType((int) 19326L),
  LogObjectType((int) 19352L),
  BaseLogEventType((int) 19362L),
  LogOverflowEventType((int) 19369L),
  LogEntryConditionClassType((int) 19370L),
  PubSubDiagnosticsType((int) 19677L),
  PubSubDiagnosticsRootType((int) 19732L),
  PubSubDiagnosticsConnectionType((int) 19786L),
  PubSubDiagnosticsWriterGroupType((int) 19834L),
  PubSubDiagnosticsReaderGroupType((int) 19903L),
  PubSubDiagnosticsDataSetWriterType((int) 19968L),
  PubSubDiagnosticsDataSetReaderType((int) 20027L),
  ReaderGroupTransportType((int) 21090L),
  ReaderGroupMessageType((int) 21091L),
  DataSetWriterMessageType((int) 21096L),
  DataSetReaderMessageType((int) 21104L),
  UadpWriterGroupMessageType((int) 21105L),
  UadpDataSetWriterMessageType((int) 21111L),
  UadpDataSetReaderMessageType((int) 21116L),
  JsonWriterGroupMessageType((int) 21126L),
  JsonDataSetWriterMessageType((int) 21128L),
  JsonDataSetReaderMessageType((int) 21130L),
  DatagramWriterGroupTransportType((int) 21133L),
  BrokerWriterGroupTransportType((int) 21136L),
  BrokerDataSetWriterTransportType((int) 21138L),
  BrokerDataSetReaderTransportType((int) 21142L),
  NetworkAddressType((int) 21145L),
  NetworkAddressUrlType((int) 21147L),
  AliasNameType((int) 23455L),
  AliasNameCategoryType((int) 23456L),
  IOrderedObjectType((int) 23513L),
  OrderedListType((int) 23518L),
  EccApplicationCertificateType((int) 23537L),
  EccNistP256ApplicationCertificateType((int) 23538L),
  EccNistP384ApplicationCertificateType((int) 23539L),
  EccBrainpoolP256r1ApplicationCertificateType((int) 23540L),
  EccBrainpoolP384r1ApplicationCertificateType((int) 23541L),
  EccCurve25519ApplicationCertificateType((int) 23542L),
  EccCurve448ApplicationCertificateType((int) 23543L),
  AuthorizationServicesConfigurationFolderType((int) 23556L),
  AuditClientEventType((int) 23606L),
  SubscribedDataSetFolderType((int) 23795L),
  StandaloneSubscribedDataSetType((int) 23828L),
  PubSubCapabilitiesType((int) 23832L),
  AuditClientUpdateMethodResultEventType((int) 23926L),
  DatagramDataSetReaderTransportType((int) 24016L),
  IIetfBaseNetworkInterfaceType((int) 24148L),
  IIeeeBaseEthernetPortType((int) 24158L),
  IBaseEthernetCapabilitiesType((int) 24167L),
  ISrClassType((int) 24169L),
  IIeeeBaseTsnStreamType((int) 24173L),
  IIeeeBaseTsnTrafficSpecificationType((int) 24179L),
  IIeeeBaseTsnStatusStreamType((int) 24183L),
  IIeeeTsnInterfaceConfigurationType((int) 24188L),
  IIeeeTsnInterfaceConfigurationTalkerType((int) 24191L),
  IIeeeTsnInterfaceConfigurationListenerType((int) 24195L),
  IIeeeTsnMacAddressType((int) 24199L),
  IIeeeTsnVlanTagType((int) 24202L),
  IPriorityMappingEntryType((int) 24205L),
  IIeeeAutoNegotiationStatusType((int) 24233L),
  UserManagementType((int) 24264L),
  IVlanIdType((int) 25218L),
  IetfBaseNetworkInterfaceType((int) 25221L),
  PriorityMappingTableType((int) 25227L),
  PubSubKeyPushTargetType((int) 25337L),
  PubSubKeyPushTargetFolderType((int) 25346L),
  PubSubConfigurationType((int) 25482L),
  ApplicationConfigurationType((int) 25731L),
  ProvisionableDeviceType((int) 26871L),
  AlarmSuppressionGroupType((int) 32064L),
  TrustListUpdateRequestedAuditEventType((int) 32260L),
  TransactionDiagnosticsType((int) 32286L),
  CertificateUpdateRequestedAuditEventType((int) 32306L),
  NonTransparentBackupRedundancyType((int) 32411L),
  SyntaxReferenceEntryType((int) 32439L),
  UnitType((int) 32442L),
  ServerUnitType((int) 32447L),
  AlternativeUnitType((int) 32467L),
  QuantityType((int) 32475L),
  QuantitiesFolderType((int) 32502L),
  HistoricalEventConfigurationType((int) 32621L),
  HistoricalExternalEventSourceType((int) 32625L),
  AuditHistoryConfigurationChangeEventType((int) 32758L),
  AuditHistoryBulkInsertEventType((int) 32803L);
  private static final Map<Integer, OpcuaNodeIdServicesObjectType> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesObjectType value : OpcuaNodeIdServicesObjectType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesObjectType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesObjectType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
