/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnDcp_Block_DevicePropertiesDeviceRole extends PnDcp_Block implements Message {

  // Accessors for discriminator values.
  public PnDcp_BlockOptions getOption() {
    return PnDcp_BlockOptions.DEVICE_PROPERTIES_OPTION;
  }

  public Short getSuboption() {
    return (short) 4;
  }

  // Properties.
  protected final boolean pnioSupervisor;
  protected final boolean pnioMultidevive;
  protected final boolean pnioController;
  protected final boolean pnioDevice;

  // Reserved Fields
  private Integer reservedField0;
  private Short reservedField1;

  public PnDcp_Block_DevicePropertiesDeviceRole(
      boolean pnioSupervisor, boolean pnioMultidevive, boolean pnioController, boolean pnioDevice) {
    super();
    this.pnioSupervisor = pnioSupervisor;
    this.pnioMultidevive = pnioMultidevive;
    this.pnioController = pnioController;
    this.pnioDevice = pnioDevice;
  }

  public boolean getPnioSupervisor() {
    return pnioSupervisor;
  }

  public boolean getPnioMultidevive() {
    return pnioMultidevive;
  }

  public boolean getPnioController() {
    return pnioController;
  }

  public boolean getPnioDevice() {
    return pnioDevice;
  }

  @Override
  protected void serializePnDcp_BlockChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnDcp_Block_DevicePropertiesDeviceRole");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (int) 0x000000,
        writeUnsignedInt(writeBuffer, 20),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (pnioSupervisor)
    writeSimpleField(
        "pnioSupervisor",
        pnioSupervisor,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (pnioMultidevive)
    writeSimpleField(
        "pnioMultidevive",
        pnioMultidevive,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (pnioController)
    writeSimpleField(
        "pnioController",
        pnioController,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (pnioDevice)
    writeSimpleField(
        "pnioDevice",
        pnioDevice,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnDcp_Block_DevicePropertiesDeviceRole");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnDcp_Block_DevicePropertiesDeviceRole _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 20;

    // Simple field (pnioSupervisor)
    lengthInBits += 1;

    // Simple field (pnioMultidevive)
    lengthInBits += 1;

    // Simple field (pnioController)
    lengthInBits += 1;

    // Simple field (pnioDevice)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static PnDcp_BlockBuilder staticParsePnDcp_BlockBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnDcp_Block_DevicePropertiesDeviceRole");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Integer reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedInt(readBuffer, 20),
            (int) 0x000000,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean pnioSupervisor =
        readSimpleField(
            "pnioSupervisor",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean pnioMultidevive =
        readSimpleField(
            "pnioMultidevive",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean pnioController =
        readSimpleField(
            "pnioController",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean pnioDevice =
        readSimpleField(
            "pnioDevice", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Short reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 8),
            (short) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnDcp_Block_DevicePropertiesDeviceRole");
    // Create the instance
    return new PnDcp_Block_DevicePropertiesDeviceRoleBuilderImpl(
        pnioSupervisor,
        pnioMultidevive,
        pnioController,
        pnioDevice,
        reservedField0,
        reservedField1);
  }

  public static class PnDcp_Block_DevicePropertiesDeviceRoleBuilderImpl
      implements PnDcp_Block.PnDcp_BlockBuilder {
    private final boolean pnioSupervisor;
    private final boolean pnioMultidevive;
    private final boolean pnioController;
    private final boolean pnioDevice;
    private final Integer reservedField0;
    private final Short reservedField1;

    public PnDcp_Block_DevicePropertiesDeviceRoleBuilderImpl(
        boolean pnioSupervisor,
        boolean pnioMultidevive,
        boolean pnioController,
        boolean pnioDevice,
        Integer reservedField0,
        Short reservedField1) {
      this.pnioSupervisor = pnioSupervisor;
      this.pnioMultidevive = pnioMultidevive;
      this.pnioController = pnioController;
      this.pnioDevice = pnioDevice;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public PnDcp_Block_DevicePropertiesDeviceRole build() {
      PnDcp_Block_DevicePropertiesDeviceRole pnDcp_Block_DevicePropertiesDeviceRole =
          new PnDcp_Block_DevicePropertiesDeviceRole(
              pnioSupervisor, pnioMultidevive, pnioController, pnioDevice);
      pnDcp_Block_DevicePropertiesDeviceRole.reservedField0 = reservedField0;
      pnDcp_Block_DevicePropertiesDeviceRole.reservedField1 = reservedField1;
      return pnDcp_Block_DevicePropertiesDeviceRole;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnDcp_Block_DevicePropertiesDeviceRole)) {
      return false;
    }
    PnDcp_Block_DevicePropertiesDeviceRole that = (PnDcp_Block_DevicePropertiesDeviceRole) o;
    return (getPnioSupervisor() == that.getPnioSupervisor())
        && (getPnioMultidevive() == that.getPnioMultidevive())
        && (getPnioController() == that.getPnioController())
        && (getPnioDevice() == that.getPnioDevice())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getPnioSupervisor(),
        getPnioMultidevive(),
        getPnioController(),
        getPnioDevice());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
