/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ControllerType {
  ANY((long) 0L),
  S7_200((long) 1L),
  S7_300((long) 2L),
  S7_400((long) 3L),
  S7_1200((long) 4L),
  S7_1500((long) 5L),
  LOGO((long) 6L);
  private static final Map<Long, ControllerType> map;

  static {
    map = new HashMap<>();
    for (ControllerType value : ControllerType.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  ControllerType(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static ControllerType enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
