<%--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
--%>
<%@page import="javax.portlet.PortletRequest" %>
<%@ taglib uri="http://java.sun.com/portlet" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setBundle basename="org.apache.portals.applications.demo.security.resources.RoleResources" />

<portlet:defineObjects/>

<h3><fmt:message key="roles.label.UserRoles"/></h3>

<c:choose>

  <c:when test="${empty renderRequest.userPrincipal}">
	  <fmt:message key="roles.label.LoginToSeeTheRoles"/>
  </c:when>

  <c:otherwise>
    <fmt:message key="roles.label.UserColon"/> <c:out value='${renderRequest.userPrincipal.name}'/><br>
    <br>
    <fmt:message key="roles.label.isUserInRole"/><br>
    <table border="1">
      <tr>
      	<th><fmt:message key="roles.label.RoleRefName"/></th>
      	<th><fmt:message key="roles.label.RoleName"/></th>
      	<th><fmt:message key="roles.label.PortletRequest"/></th>
      	<th><fmt:message key="roles.label.ServletRequest"/></th>
      </tr>
      <tr>
      	<td><fmt:message key="roles.label.Administrator"/></td>
      	<td><fmt:message key="roles.label.admin"/></td>
      	<td><%= renderRequest.isUserInRole("admin") %></td>
      	<td><%= request.isUserInRole("admin") %></td>
      </tr>
      <tr>
      	<td><fmt:message key="roles.label.Manager"/></td>
      	<td><fmt:message key="roles.label.manager"/></td>
      	<td><%= renderRequest.isUserInRole("manager") %></td>
      	<td><%= request.isUserInRole("manager") %></td>
      </tr>
      <tr>
      	<td><fmt:message key="roles.label.User"/></td>
      	<td><fmt:message key="roles.label.user"/></td>
      	<td><%= renderRequest.isUserInRole("user") %></td>
      	<td><%= request.isUserInRole("user") %></td>
    	</tr>
    </table>
  </c:otherwise>

</c:choose>
<br>
<fmt:message key="roles.label.ForHelpOnRoleConfig"/>
