/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy.impl;

import java.util.ArrayList;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent.proxy.URICleaner;

/**
 * DefaultURICleanerImpl
 * 
 * @version $Id$
 */
public class DefaultURICleanerImpl implements URICleaner
{
    private String [] searchList = { " " };
    private String [] replacementList = { "%20" };
    
    public DefaultURICleanerImpl() 
    {
    }
    
    public void setSearchList(String[] searchList)
    {
        ArrayList<String> searchArrayList = new ArrayList<String>();
        
        // Always replace spaces
        if (!ArrayUtils.contains(searchList, " ")) {
            searchArrayList.add(" ");
        }
        
        if (searchList != null) {
            for (String search : searchList) {
                searchArrayList.add(search);
            }
        }
        
        this.searchList = searchArrayList.toArray(new String[searchArrayList.size()]);
    }

    public void setReplacementList(String[] replacementList)
    {
        ArrayList<String> replacementArrayList = new ArrayList<String>();
        
        // Always replace spaces
        if (!ArrayUtils.contains(replacementList, "%20")) {
            replacementArrayList.add("%20");
        }
        
        if (replacementList != null) {
            for (String replace : replacementList) {
                replacementArrayList.add(replace);
            }
        }
        
        this.replacementList = replacementArrayList.toArray(new String[replacementArrayList.size()]);
    }

    public String clean(String uri)
    {
        return StringUtils.replaceEach(uri, searchList, replacementList);
    }
}
