/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

import junit.framework.TestCase;

import org.apache.portals.applications.webcontent.proxy.impl.DefaultURICleanerImpl;

/**
 * @version $Id$
 */
public class TestURICleaner extends TestCase
{
    public void testDefaultURICleaner() throws Exception
    {
        String wrongUriWithSpace = "http://SERVER/0/F8C57293124EDBF9C125783200376835/$FILE/EXXO-ADDM-2011-000020-01 (p2).doc";
        
        DefaultURICleanerImpl uriCleaner = new DefaultURICleanerImpl();
        uriCleaner.setSearchList(new String [] { " " });
        uriCleaner.setReplacementList(new String [] { "%20" });
        String cleanedUri = uriCleaner.clean(wrongUriWithSpace);
        assertEquals("http://SERVER/0/F8C57293124EDBF9C125783200376835/$FILE/EXXO-ADDM-2011-000020-01%20(p2).doc", cleanedUri);

        wrongUriWithSpace = "http://SERVER/0/F8C57293124EDBF9C125783200376835/$FILE/EXXO-ADDM-2011-000020-01 (p2)^^^.doc";
        uriCleaner.setSearchList(new String [] { " ", "^" });
        uriCleaner.setReplacementList(new String [] { "%20", "%5E" });
        cleanedUri = uriCleaner.clean(wrongUriWithSpace);
        assertEquals("http://SERVER/0/F8C57293124EDBF9C125783200376835/$FILE/EXXO-ADDM-2011-000020-01%20(p2)%5E%5E%5E.doc", cleanedUri);
    }   
}
