/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.Test;

public class SimpleProxyMappingTest
{

    @Test
    public void testSimpleMappings() throws Exception
    {
        SimpleProxyMapping mapping = new SimpleProxyMapping();
        mapping.setLocal("/portals/applications/");
        mapping.setRemote(URI.create("http://portals.apache.org/applications/"));

        assertTrue(mapping.matchesLocal("/portals/applications/"));
        assertTrue(mapping.matchesLocal("/portals/applications/webcontent2/index.html"));

        assertTrue(mapping.matchesRemote(URI.create("http://portals.apache.org/applications/")));
        assertTrue(mapping.matchesRemote(URI.create("http://portals.apache.org/applications/webcontent2/index.html")));

        assertEquals("http://portals.apache.org/applications/", mapping.resolveRemoteFromLocal("/portals/applications/"));
        assertEquals("http://portals.apache.org/applications/webcontent2/index.html", mapping.resolveRemoteFromLocal("/portals/applications/webcontent2/index.html"));

        assertEquals("/portals/applications/", mapping.resolveLocalFromRemote(URI.create("http://portals.apache.org/applications/")));
        assertEquals("/portals/applications/webcontent2/index.html", mapping.resolveLocalFromRemote(URI.create("http://portals.apache.org/applications/webcontent2/index.html")));
    }

    @Test
    public void testSimpleMappingsWithoutScheme() throws Exception
    {
        SimpleProxyMapping mapping = new SimpleProxyMapping();
        mapping.setLocal("/portals/applications/");
        mapping.setRemote(URI.create("//portals.apache.org/applications/"));

        assertTrue(mapping.matchesLocal("/portals/applications/"));
        assertTrue(mapping.matchesLocal("/portals/applications/webcontent2/index.html"));

        assertTrue(mapping.matchesRemote(URI.create("http://portals.apache.org/applications/")));
        assertTrue(mapping.matchesRemote(URI.create("http://portals.apache.org/applications/webcontent2/index.html")));

        assertEquals("//portals.apache.org/applications/", mapping.resolveRemoteFromLocal("/portals/applications/"));
        assertEquals("//portals.apache.org/applications/webcontent2/index.html", mapping.resolveRemoteFromLocal("/portals/applications/webcontent2/index.html"));

        assertEquals("/portals/applications/", mapping.resolveLocalFromRemote(URI.create("http://portals.apache.org/applications/")));
        assertEquals("/portals/applications/webcontent2/index.html", mapping.resolveLocalFromRemote(URI.create("http://portals.apache.org/applications/webcontent2/index.html")));
    }
}
