/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.portlet.history;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

/**
 * Web content page
 */
public class WebContentPage implements Serializable
{
    private static final long serialVersionUID = 1L;

    private String method;
    private String url;
    private Map<String, String[]> params;

    public WebContentPage(String url)
    {
        this(url, null);
    }

    public WebContentPage(String url, String method)
    {
        this(url, method, null);
    }

    public WebContentPage(String url, String method, Map<String, String[]> params)
    {
        if (url == null)
        {
            throw new IllegalArgumentException("url must not be null.");
        }

        this.url = url;
        this.method = method;
        this.params = new LinkedHashMap<String, String[]>();

        if (params != null)
        {
            this.params.putAll(params);
        }
    }

    public String getMethod()
    {
        return method;
    }

    public String getUrl()
    {
        return url;
    }

    public Map<String, String[]> getParams()
    {
        return Collections.unmodifiableMap(params);
    }

    @Override
    public boolean equals(Object o)
    {
        if (o == null || !(o instanceof WebContentPage))
        {
            return false;
        }

        WebContentPage other = (WebContentPage) o;
        return (StringUtils.equals(other.url, this.url) && StringUtils.equals(other.method, this.method) && other.params.equals(this.params));
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder(super.toString()).append(' ');
        sb.append("[").append(method).append(": ").append(url).append(", params: ").append(params).append("]");
        return sb.toString();
    }
}
