/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.jgoodies.plaf.plastic;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.tp23.jgoodies.clearlook.ClearLookMode;
import org.tp23.jgoodies.plaf.plastic.FontSizeHints;
import org.tp23.jgoodies.plaf.plastic.LookUtils;

public final class Options {
    public static final String PLASTIC_NAME = "org.tp23.jgoodies.plaf.plastic.PlasticLookAndFeel";
    public static final String PLASTIC3D_NAME = "org.tp23.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_NAME = "org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
    public static final String DEFAULT_LOOK_NAME = "org.tp23.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    private static final Map LAF_REPLACEMENTS = new HashMap();
    public static final String MENU_FONT_KEY = "jgoodies.menuFont";
    public static final String CONTROL_FONT_KEY = "jgoodies.controlFont";
    public static final String FONT_SIZE_HINTS_KEY = "jgoodies.fontSizeHints";
    public static final String USE_SYSTEM_FONTS_KEY = "swing.useSystemFontSettings";
    public static final String USE_SYSTEM_FONTS_APP_KEY = "Application.useSystemFontSettings";
    public static final String DEFAULT_ICON_SIZE_KEY = "jgoodies.defaultIconSize";
    public static final String USE_NARROW_BUTTONS_KEY = "jgoodies.useNarrowButtons";
    public static final String TAB_ICONS_ENABLED_KEY = "jgoodies.tabIconsEnabled";
    public static final String POPUP_DROP_SHADOW_ENABLED_KEY = "jgoodies.popupDropShadowEnabled";
    public static final String CLEAR_LOOK_MODE_KEY = "ClearLook.mode";
    public static final String CLEAR_LOOK_POLICY_KEY = "ClearLook.policy";
    public static final String CLEAR_LOOK_OFF;
    public static final String CLEAR_LOOK_ON;
    public static final String CLEAR_LOOK_VERBOSE;
    public static final String CLEAR_LOOK_DEBUG;
    public static final String IS_NARROW_KEY = "jgoodies.isNarrow";
    public static final String IS_ETCHED_KEY = "jgoodies.isEtched";
    public static final String HEADER_STYLE_KEY = "jgoodies.headerStyle";
    public static final String NO_ICONS_KEY = "jgoodies.noIcons";
    public static final String TREE_LINE_STYLE_KEY = "JTree.lineStyle";
    public static final String TREE_LINE_STYLE_ANGLED_VALUE = "Angled";
    public static final String TREE_LINE_STYLE_NONE_VALUE = "None";
    public static final String NO_CONTENT_BORDER_KEY = "jgoodies.noContentBorder";
    public static final String EMBEDDED_TABS_KEY = "jgoodies.embeddedTabs";
    private static final Dimension DEFAULT_ICON_SIZE;

    static {
        Options.initializeDefaultReplacements();
        CLEAR_LOOK_OFF = ClearLookMode.OFF.getName();
        CLEAR_LOOK_ON = ClearLookMode.ON.getName();
        CLEAR_LOOK_VERBOSE = ClearLookMode.VERBOSE.getName();
        CLEAR_LOOK_DEBUG = ClearLookMode.DEBUG.getName();
        DEFAULT_ICON_SIZE = new Dimension(20, 20);
    }

    private Options() {
    }

    public static boolean getUseSystemFonts() {
        return UIManager.get(USE_SYSTEM_FONTS_APP_KEY).equals(Boolean.TRUE);
    }

    public static void setUseSystemFonts(boolean useSystemFonts) {
        UIManager.put(USE_SYSTEM_FONTS_APP_KEY, useSystemFonts);
    }

    public static Dimension getDefaultIconSize() {
        Dimension size = UIManager.getDimension(DEFAULT_ICON_SIZE_KEY);
        return size == null ? DEFAULT_ICON_SIZE : size;
    }

    public static void setDefaultIconSize(Dimension defaultIconSize) {
        UIManager.put(DEFAULT_ICON_SIZE_KEY, defaultIconSize);
    }

    public static FontSizeHints getGlobalFontSizeHints() {
        Object value = UIManager.get(FONT_SIZE_HINTS_KEY);
        if (value != null) {
            return (FontSizeHints)value;
        }
        String name = LookUtils.getSystemProperty(FONT_SIZE_HINTS_KEY, "");
        try {
            return FontSizeHints.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return FontSizeHints.DEFAULT;
        }
    }

    public static void setGlobalFontSizeHints(FontSizeHints hints) {
        UIManager.put(FONT_SIZE_HINTS_KEY, hints);
    }

    public static boolean getUseNarrowButtons() {
        return UIManager.getBoolean(USE_NARROW_BUTTONS_KEY);
    }

    public static void setUseNarrowButtons(boolean b) {
        UIManager.put(USE_NARROW_BUTTONS_KEY, b);
    }

    public static boolean isTabIconsEnabled() {
        boolean result;
        if (!LookUtils.IS_NETBEANS) {
            return true;
        }
        String userMode = LookUtils.getSystemProperty(TAB_ICONS_ENABLED_KEY, "");
        boolean overridden = userMode.length() > 0;
        boolean bl = result = overridden ? userMode.equalsIgnoreCase("true") : Boolean.TRUE.equals(UIManager.get(TAB_ICONS_ENABLED_KEY));
        if (overridden) {
            LookUtils.log("You have " + (result ? "en" : "dis") + "abled icons in tabbed panes.");
        }
        return result;
    }

    public static void setTabIconsEnabled(boolean b) {
        UIManager.put(TAB_ICONS_ENABLED_KEY, b);
    }

    public static boolean isPopupDropShadowActive() {
        boolean platformProvidesNativeDropShadows = LookUtils.IS_OS_MAC;
        return !platformProvidesNativeDropShadows && Options.isPopupDropShadowEnabled();
    }

    public static boolean isPopupDropShadowEnabled() {
        boolean result;
        String userMode = LookUtils.getSystemProperty(POPUP_DROP_SHADOW_ENABLED_KEY, "");
        boolean overridden = userMode.length() > 0;
        Object value = UIManager.get(POPUP_DROP_SHADOW_ENABLED_KEY);
        if (overridden) {
            result = userMode.equalsIgnoreCase("true");
        } else {
            boolean bl = result = value == null ? Options.isPopupDropShadowEnabledDefault() : Boolean.TRUE.equals(value);
        }
        if (overridden) {
            LookUtils.log("You have " + (result ? "en" : "dis") + "abled drop shadows in popup menus.");
        }
        return result;
    }

    public static void setPopupDropShadowEnabled(boolean b) {
        UIManager.put(POPUP_DROP_SHADOW_ENABLED_KEY, b);
    }

    private static boolean isPopupDropShadowEnabledDefault() {
        return false;
    }

    public static void putLookAndFeelReplacement(String original, String replacement) {
        LAF_REPLACEMENTS.put(original, replacement);
    }

    public static void removeLookAndFeelReplacement(String original) {
        LAF_REPLACEMENTS.remove(original);
    }

    public static void initializeDefaultReplacements() {
        Options.putLookAndFeelReplacement("javax.swing.plaf.metal.MetalLookAndFeel", "org.tp23.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
    }

    public static String getReplacementClassNameFor(String className) {
        String replacement = (String)LAF_REPLACEMENTS.get(className);
        return replacement == null ? className : replacement;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "org.tp23.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    }

    public static String getSystemLookAndFeelClassName() {
        return Options.getCrossPlatformLookAndFeelClassName();
    }
}

