package org.apache.jetspeed.portlet;

/**
 * This feature is an addition to the <CODE>Portlet</CODE> interface. To support
 * session features in the portlet, this interface has to be implemented 
 * additionally to the <CODE>Portlet</CODE> interface.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @since Version 1.1
 */
public interface PortletSessionListener
{

    /**
     ** Called by the portlet container to ask the portlet to
     ** initialize a personalized user experience.
     **
     ** <P>
     ** In addition to initializing the session this method allows the
     ** portlet to initialize the concrete portlet instance, for example, to
     ** store attributes in the session.
     ** </P>
     **
     ** @param   request
     **          the portlet request
     **
     ** @exception   PortletException
     **              if the portlet has trouble fulfilling the
     **              request
     **/

    public void login (PortletRequest request) throws PortletException;

    /**
     ** Called by the portlet container to indicate that a concrete
     ** portlet instance is being removed.
     **
     ** <P>
     ** This method gives the concrete portlet instance an
     ** opportunity to clean up any resources (for example, memory,
     ** file handles, threads), before it is removed. This happens
     ** if the user logs out, or decides to remove this portlet from
     ** a page.
     ** </P>
     **
     ** @param   session
     **          the portlet session
     **
     ** @exception   PortletException
     **              if the portlet has trouble fulfilling the
     **              request
     **/

    public void logout (PortletSession session) throws PortletException;

}
