package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;
import org.apache.jetspeed.portletcontainer.util.*;

// java
import java.util.*;
import java.io.*;
import java.lang.ClassNotFoundException;

public class PortletDataImpl implements PortletData
{
    private PortletInstanceEntry portletInstance = null;
    private PortletEntry rootPortlet = null;
    private PortletRequest portletRequest = null;
    private PortletContextImpl portletContext = null;
    private PortalInformationProvider provider = null;
    private HashMap attributes = null;
    private boolean isDirty = false;

    public PortletDataImpl(PortletInstanceEntry portletInstance,
                           PortletRequest portletRequest,
                           PortletContextImpl portletContext,
                           PortalInformationProvider provider)
    {
        this.portletInstance = portletInstance;
        this.portletRequest = portletRequest;
        this.portletContext = portletContext;
        this.provider = provider;
        
        rootPortlet = portletInstance.getConcretePortlet().getRootPortlet();
    }

    public void setAttribute (String name, Object value) throws AccessDeniedException
    {
        if (!isInitialized())
            init();

        if (!isAllowed())
            throw new AccessDeniedException();

        attributes.put( name, value );
        setDirty(true);
    }

    public Object getAttribute (String name)
    {
        if (!isInitialized())
            init();

        if (!this.portletInstance.isParameterValueAvailable(name))
        { // not loaded yet, so load it now
            Object value = this.portletInstance.loadParameterValue(name);
            if (value instanceof String)
            {
                attributes.put( name, value );
            }
            else if (value instanceof byte[])
            {
                Object _value = convertToObject((byte[])value);
                if (_value == null)
                {
                    org.apache.turbine.util.Log.error("PortletDataImpl.getAttribute() - Could not read object '"+name+"'.");
                    return null;
                }
                attributes.put( name, _value );
            }
            else {
                return null;
            }
        }
        return attributes.get( name );
    }

    public Enumeration getAttributeNames ()
    {
        if (!isInitialized())
            init();

        return new Hashtable(attributes).keys();
    }

    public void removeAttribute (String name) throws AccessDeniedException
    {
        if (!isInitialized())
            init();

        if (!isAllowed())
            throw new AccessDeniedException();

        attributes.remove( name );        
        setDirty(true);
    }

    public void removeAllAttributes () throws AccessDeniedException
    {
        if (!isInitialized())
            init();

        if (!isAllowed())
            throw new AccessDeniedException();

        attributes.clear();
        setDirty(true);
    }

    public void store() throws AccessDeniedException, java.io.IOException
    {
        if (!isInitialized())
            init();

        if (!isAllowed())
            throw new AccessDeniedException();

        if (isDirty()) {
            if (portletInstance!=null) {

                Map originalAttributes = portletInstance.getParameters();

                Hashtable attributesToStore = new Hashtable();
                attributesToStore.putAll( attributes );

                // deserialize all attributes values
                Enumeration names = attributesToStore.keys();
                while (names.hasMoreElements())
                {
                    String name = (String)names.nextElement();
                    Object value = attributesToStore.get(name);

                    if (!originalAttributes.containsKey(name))
                    { // original attributes does not contain the new attribute. So it is a new one

                        if ((!(value instanceof String)) && (!(value instanceof byte[])))
                        {
                            byte[] _value = convertToByte(value);
                            attributesToStore.put(name, (Object)_value);
                        }
                    }
                    else if (this.portletInstance.isParameterValueAvailable(name))
                    {
                        if ((!(value instanceof String)) && (!(value instanceof byte[])))
                        {
                            byte[] _value = convertToByte(value);
                            attributesToStore.put(name, (Object)_value);
                        }
                    }
                }

                try {
                    portletInstance.setParameters( attributesToStore );
                    provider.setPortletInstanceEntry(portletInstance);
                }
                catch (java.io.IOException e) {
                    org.apache.turbine.util.Log.error("PortletDataImpl.store: Unable to store portlet instance data. PIID: "+portletInstance.getPiid(),e);
                    throw e;
                }
                setDirty(false);
            }
        }
        
    }

    // additional methods

    /**
     * Returns true if the data was changed
     * 
     * @return a boolean indicating a change of the data
     */
    public boolean isDirty()
    {
        return isDirty;
    }

    private void addAllFrom (Map parameters)
    {
        attributes.putAll(parameters);
        Iterator iterator = attributes.keySet().iterator();
        while (iterator.hasNext())
        {
            String name = (String)iterator.next();
            Object value = attributes.get(name);
            if (value instanceof byte[])
            {
                Object _value = convertToObject((byte[])value);
                if (_value == null)
                    org.apache.turbine.util.Log.error("PortletDataImpl.addAllFrom() - Could not read object.");
                else {
                    attributes.put(name, _value);
                }
            }
        }
        setDirty(false);
    }

    private void setDirty(boolean dirty)
    {
        isDirty = dirty;
    }

    private boolean isInitialized()
    {
        return attributes!=null;
    }

    private boolean isAllowed()
    {
        if (org.apache.turbine.services.resources.TurbineResources.getBoolean(
            Constants.RESTRICT_ACCESS,true))
        {
            if (!com.ibm.wps.util.ListenerConverter.isIgnoreModeToStoreData(
                ((com.ibm.wps.portletcontainer.PortletEntryImpl)rootPortlet).getListeners()) )
            {
                Portlet.Mode portletMode = 
                    (Portlet.Mode)ThreadAttributesManager.getAttribute(Constants.PORTLET_MODE);
                if (portletMode==null)
                    return false;
                if (portletMode!=Portlet.Mode.EDIT)
                    return false;
            }
        }
        return true;
    }

    private void init()
    {
        // allow late initialization of attributes, because the servlet's classloader is needed here
        // so this function is called in the target WebModule
        if (!isInitialized()) {
            attributes = new HashMap();
            if (this.portletInstance!=null)
            {
                addAllFrom( this.portletInstance.getParameters() );
                setDirty(false);
            }
        }
    }

    private Object convertToObject(byte[] data)
    {
        try {
            PortletAppObjectInputStream objectStream =
                new PortletAppObjectInputStream(new ByteArrayInputStream(data));
            objectStream.setClassLoader(portletContext.getServletClassLoader());
            return (Object) objectStream.readObject();
        }
        catch (IOException e) {
            org.apache.turbine.util.Log.error("PortletDataImpl.convertToObject(byte[]) - Could not read object.",e);
            return null;
        }
        catch (ClassNotFoundException e) {
            org.apache.turbine.util.Log.error("PortletDataImpl.convertToObject(byte[]) - Could not read object.",e);
            return null;
        }
    }

    private byte[] convertToByte(Object data)
    {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4000);
            PortletAppObjectOutputStream objectStream =
                new PortletAppObjectOutputStream(byteArrayOutputStream);
            objectStream.setClassLoader(portletContext.getServletClassLoader());
            objectStream.writeObject(data);
            return byteArrayOutputStream.toByteArray();
        }
        catch (StreamCorruptedException e) {
            org.apache.turbine.util.Log.error("PortletDataImpl.convertToByte(byte[]) - Could not read object.",e);
            return null;
        }
        catch (IOException e) {
            org.apache.turbine.util.Log.error("PortletDataImpl.convertToByte(byte[]) - Could not read object.",e);
            return null;
        }
    }

}
