package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;

import com.ibm.logging.*;
import com.ibm.logging.mgr.*;


public class PortletLogImpl implements PortletLog
{
    private static final PortletLogImpl instance = new PortletLogImpl();

    public static PortletLog getInstance()
    {
        return instance;
    }

    private ILogger msgLog;
    private ILogger trcLog;

    private PortletLogImpl()
    {
        LogManager logMgr = LogManager.getManager();
        msgLog = logMgr.getMessageLogger("PortletMessageLogger");
        trcLog = logMgr.getMessageLogger("PortletTraceLogger");
    }

    protected void finalize() throws Throwable
    {
        LogManager logMgr = LogManager.getManager();
        logMgr.returnObject(msgLog);
        logMgr.returnObject(trcLog);
    }


    public boolean isDebugEnabled ()
    {
        return trcLog.isLogging();
    }

    public void debug (String text)
    {
        if (isDebugEnabled())
            trcLog.text(IRecordType.TYPE_INFO, this, "debug(String)", text);
    }

    public boolean isInfoEnabled ()
    {
        return trcLog.isLogging();
    }

    public void info (String text)
    {
        if (isInfoEnabled ())
            trcLog.text(IRecordType.TYPE_INFO, this, "info(String)", text);
    }

    public boolean isWarnEnabled ()
    {
        return msgLog.isLogging();
    }

    public void warn (String text)
    {
        if (isWarnEnabled ())
            msgLog.text(IRecordType.TYPE_WARN, this, "warn(String)", text);
    }

    public boolean isErrorEnabled ()
    {
        return msgLog.isLogging();
    }

    public void error (String text)
    {
        if (isErrorEnabled())
            msgLog.text(IRecordType.TYPE_ERROR, this, "warn(String)", text);
    }

    public void error (String text, Throwable cause)
    {
        if (isErrorEnabled()) {
            msgLog.text(IRecordType.TYPE_ERROR, this, "error(String, Throwable)", text);
            msgLog.exception(IRecordType.TYPE_ERROR, this, "error(String, Throwable)", cause);
        }
    }
}
