package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.PortletSession;
import org.apache.jetspeed.portlet.PortletException;
import org.apache.jetspeed.portlet.User;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.filter.*;

import org.apache.turbine.util.Log;
import org.apache.turbine.services.resources.TurbineResources;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class PortletSessionImpl implements PortletSession
{
    private PortletSessionData sessionData = null;
    private HttpSession httpSession = null;
    private UserImpl user = null;

    private PortletSessionFilter sessionFilter = null;

    public PortletSessionImpl( PortletSessionData sessionData,
                               HttpSession session )
    {
        this.sessionData = sessionData;
        this.httpSession = session;

        // SHESMER - TODO - check with Ingo
        UserInformation user = UserInformationAccess.getUserInformation( httpSession );
        if (user!=null)
            this.user = new UserImpl( user );

        initFilter();
    }

    public void access( )
    {
        sessionData.access();
    }

    public Object getAttribute(String name)
    {
        Object attribute = httpSession.getAttribute(
            PortletNamespaceMapper.encode( sessionData.getCAiid(), 
                                           name ) );
        if (attribute == null) // if the attribute was not found in the portlet session check if it is in the http session
            attribute = httpSession.getAttribute(name );
        return attribute;
    }

    public Enumeration getAttributeNames ()
    {
/* TODO: Should we allow to show servlet attributes through to portlets?
         This could show WPS or other attributes to each portlst
*/        
        Vector session_attributes = new Vector();
        Enumeration attributes = httpSession.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String element = (String)attributes.nextElement();
            if (PortletNamespaceMapper.isInNamespace( sessionData.getCAiid(), element)) {
                session_attributes.add(
                    PortletNamespaceMapper.decode( sessionData.getCAiid(), element) );
            }
        }
        return session_attributes.elements();
    }

    public void removeAttribute (String name)
    {
        httpSession.removeAttribute(
            PortletNamespaceMapper.encode( sessionData.getCAiid(), name ) );
// TODO: should we really want to go directly to the servlet request and delete the attribute ?
    }

    public void removeAttributes()
    {
        Enumeration attributes = httpSession.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            if (PortletNamespaceMapper.isInNamespace( sessionData.getCAiid(), name )) {
                httpSession.removeAttribute(name);
            }
        }
// TODO: should we really want to go directly to the servlet request and delete the attribute ?
    }

    public void setAttribute(String name, Object value)
    {
        httpSession.setAttribute(PortletNamespaceMapper.encode( sessionData.getCAiid(), name ), value );
    }

    public long getCreationTime ()
    {
        return sessionData.getCreationTime();
    }

    public long getLastAccessedTime ()
    {
        return sessionData.getLastAccessedTime();
    }

    public User getUser ()
    {
        // deprecated
        return this.user;
    }

    // servlet methods, which cannot be changed by the filter, because they are deprecated

    public HttpSessionContext getSessionContext()
    {
        // deprectated
        return httpSession.getSessionContext();
    }

    public String[] getValueNames()
    {
        // deprectated
        Enumeration enum = getAttributeNames();
        int count = 0;
        while (enum.hasMoreElements())
        {
            count++;
            enum.nextElement();
        }
        String[] valueNames = new String[count];
        enum = getAttributeNames();
        count = 0;
        while (enum.hasMoreElements())
        {
            valueNames[count++] = (String)enum.nextElement();
        }
        return valueNames;
    }

    public Object getValue(String name)
    {
        // deprectated
        return getAttribute(name);
    }

    public void removeValue(String name)
    {
        // deprectated
        removeAttribute(name);
    }

    public void putValue(String name, Object value)
    {
        // deprectated
        setAttribute(name,value);
    }

    // servlet methods, which can be changed by the filter

    public String getId()
    {
        // TODO: to get a unique key we need to add the PIID or the AIID
        return sessionFilter.getId();
    }

    public void setMaxInactiveInterval(int interval)
    {
        sessionFilter.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval()
    {
        return sessionFilter.getMaxInactiveInterval();
    }

    public void invalidate()
    {
        sessionFilter.invalidate();
    }

    public boolean isNew()
    {
        // TODO
        return sessionFilter.isNew();
    }

    // additional methods

    public HttpSession getServletSession()
    {
        return httpSession;
    }

    public void setHttpSession(HttpSession httpSession)
    {
        this.httpSession = httpSession;
        sessionFilter.setHttpSession(httpSession);
    }

    public PortletSessionData getSessionData()
    {
        return sessionData;
    }

    public Object getPrivateAttribute(String name)
    {
        return httpSession.getAttribute(PortletNamespaceMapper.encode( "PRIVATE", 
                                                                       sessionData.getCAiid(), 
                                                                       name ) );
    }

    public Enumeration getPrivateAttributeNames ()
    {
        Vector session_attributes = new Vector();
        Enumeration attributes = httpSession.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String element = (String)attributes.nextElement();
            if (PortletNamespaceMapper.isInNamespace( "PRIVATE", 
                                                      sessionData.getCAiid(), 
                                                      element)) {
                session_attributes.add(
                    PortletNamespaceMapper.decode( "PRIVATE", 
                                                   sessionData.getCAiid(), 
                                                   element) );
            }
        }
        return session_attributes.elements();
    }

    public void removePrivateAttribute (String name)
    {
        httpSession.removeAttribute(
            PortletNamespaceMapper.encode( "PRIVATE", 
                                           sessionData.getCAiid(), 
                                           name ) );
    }

    public void removePrivateAttributes()
    {
        Enumeration attributes = httpSession.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            if (PortletNamespaceMapper.isInNamespace( "PRIVATE", 
                                                      sessionData.getCAiid(), 
                                                      name )) {
                httpSession.removeAttribute(name);
            }
        }
    }

    public void setPrivateAttribute(String name, Object value)
    {
        httpSession.setAttribute(
            PortletNamespaceMapper.encode( "PRIVATE", 
                                           sessionData.getCAiid(), 
                                           name ), 
            value );
    }

    private void initFilter()
    {
        String filterClassName = TurbineResources.getString("portletcontainer.filter.session");
        if (filterClassName==null) {
            sessionFilter = new PortletSessionFilter(httpSession,
                                                     this);
        }
        else {
            Class[] parameterClasses = {HttpSession.class, PortletSession.class};
            Constructor constructor = null;
            try {
                constructor = Class.forName(filterClassName).getConstructor(parameterClasses);
            }
            catch (NoSuchMethodException e) {
                Log.error("Invalid PortletSessionFilter defined in resources key portletcontainer.filter.session.",e);
                throw new IllegalArgumentException("Invalid PortletSessionFilter defined in resources key portletcontainer.filter.session.");
            }
            catch (ClassNotFoundException e) {
                Log.error("Invalid PortletSessionFilter defined in resources key portletcontainer.filter.session.",e);
                throw new IllegalArgumentException("Invalid PortletSessionFilter defined in resources key portletcontainer.filter.session.");
            }
            Object[] parameters = {httpSession, this };
            try {
                Object filter = constructor.newInstance(parameters);
                if (!(filter instanceof PortletSessionFilter)) {
                    Log.error("PortletSessionFilter defined in resources key portletcontainer.filter.session does not derive from PortletSessionFilter.");
                    throw new IllegalArgumentException("PortletSessionFilter defined in resources key portletcontainer.filter.session does not derive from PortletSessionFilter.");
                }
                sessionFilter = (PortletSessionFilter)filter;
            }
            catch (InstantiationException e) {
                Log.error("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.",e);
                throw new IllegalArgumentException("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.");
            }
            catch (IllegalAccessException e) {
                Log.error("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.",e);
                throw new IllegalArgumentException("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.");
            }
            catch (InvocationTargetException e) {
                Log.error("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.",e);
                throw new IllegalArgumentException("PortletSessionFilter defined in resources key portletcontainer.filter.session could not be instantiated.");
            }
        }
    }

}
