package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import org.apache.jetspeed.portlet.event.ActionListener;

import org.apache.turbine.util.*;

// java
import javax.servlet.http.*;
import java.lang.reflect.*;
import java.lang.*;
import java.util.*;

public class PortletURIImpl implements PortletURI
{
    private PortletInstanceEntry    portletInstance = null;
    private Portlet.Mode            mode = null;
    private PortletWindow.State     state = null;
    private PortletRequestImpl      portletRequest = null;
    private HttpServletResponse     servletResponse = null;
    private Hashtable               parameters = new Hashtable();
    private String                  actionreference = null;
    private boolean                 returnURI = false;

    private String                  uriHost = null;
    private String                  uriPath = null;
    private String                  uriParameters = null;
    private String                  uriSession = null;
    private String                  uriAnchor = null;



    /**
     * String array with invalid Characters:
     * \
     * /
     * :
     * *
     * "
     * <
     * >
     * |
     * +
     * ?
     */
    public static final String[] INVALID_CHARACTERS = { "$",
        "\\", 
        "/", 
        ":", 
        "*", 
        "\"", 
        "<",
        ">", 
        "|", 
        "+", 
        "?"
    };

    public static final String[] CODED_CHARACTERS = { "$" + (int)'$' , 
        "$" + (int)'\\', 
        "$" + (int)'/' ,
        "$" + (int)':' ,
        "$" + (int)'*' ,
        "$" + (int)'"' ,
        "$" + (int)'<' ,
        "$" + (int)'>' ,
        "$" + (int)'|' ,
        "$" + (int)'+' ,
        "$" + (int)'?' 
    };



    public PortletURIImpl( PortletInstanceEntry portletInstance,
                           PortletRequestImpl request,
                           HttpServletResponse response )
    {
        this.portletInstance = portletInstance;
        this.portletRequest = request;
        this.servletResponse = response;
        this.returnURI = true;
    }

    public PortletURIImpl( PortletInstanceEntry portletInstance,
                           Portlet.Mode mode,
                           PortletWindow.State state,
                           PortletRequestImpl request,
                           HttpServletResponse response )
    {
        if ((state==PortletWindow.State.MOVING) || (state==PortletWindow.State.RESIZING))
        {
            throw new IllegalArgumentException("Invalid PortletWindow.State. No -ING states are allowed.");
        }
        this.portletInstance = portletInstance;
        this.mode = mode;
        this.state = state;
        this.portletRequest = request;
        this.servletResponse = response;
        this.returnURI = false;
    }

    public void addParameter (String name, String value)
    {
        // encode name and value first -> replace invalid characters
        parameters.put(PortletNamespaceMapper.encode(portletInstance.getPiid(),encode(name)), 
                       encode(value));
    }

    /**
     * <TT>encode</TT> replaces all invalid characters in
     * a String with '%' followed by the hex code of
     * the invalid character
     * 
     * @param toEncode the String to encode
     * @return the encoded String
     * @see String decode(String toDecode)
     * @see INVALID_CHARACTERS
     */
    public static String encode(String toEncode)
    {
        return processCoding(toEncode,INVALID_CHARACTERS,CODED_CHARACTERS);
    }

    /**
     * <TT>decode</TT> replaces all encoded characters in
     * a String with the original characters
     * 
     * @param toDecode the String to decode
     * @return the decoded String
     * @see String encode(String toEncode)
     * @see INVALID_CHARACTERS
     */
    public static String decode(String toDecode)
    {
        return processCoding(toDecode,CODED_CHARACTERS,INVALID_CHARACTERS);
    }

    /** internal helper method for en-/decode */
    private static String processCoding(String toEncode, String[] oldChars, String[] newChars)
    {

        for (int i = 0; i < oldChars.length; i++)
        {

            int idx    = 0;
            StringBuffer partEncoded = new StringBuffer();

            while ((idx = toEncode.indexOf(oldChars[i])) > -1)
            {
                partEncoded.append(toEncode.substring(0,idx));
                partEncoded.append(newChars[i]);
                toEncode = toEncode.substring(idx+oldChars[i].length());
            }
            toEncode = partEncoded.append(toEncode).toString();
        }

        return toEncode;
    }


    public void addAction (PortletAction action)
    {
        actionreference = PortletActionManager.storePortletAction(action,
                                                                  portletInstance,
                                                                  portletRequest.getProvider(),
                                                                  (PortletSessionImpl)portletRequest.getPortletSession());
    }

    public String toString ()
    {
        splitURI();

        StringBuffer buffer = new StringBuffer(uriHost);
        if (uriPath!=null) buffer.append(uriPath);

        if (parameters.size()>0)
        {
            Enumeration parameternames = parameters.keys();
            while (parameternames.hasMoreElements())
            {
                String name = (String)parameternames.nextElement();
                String value = (String)parameters.get(name);
                buffer.append('/');
                buffer.append(name);
                buffer.append('/');
                buffer.append(value);
            }
        }

        if (uriParameters!=null) buffer.append(uriParameters);

        if (uriAnchor != null)
        {
            buffer.append(uriAnchor);
        }

        String returnURI = null;
        if (uriSession!=null)
        {
            buffer.append(uriSession);
            returnURI = buffer.toString();
        }
        else
        {
            returnURI = servletResponse.encodeURL(buffer.toString());
        }

        return returnURI;
    }

    private void splitURI()
    {
        String completeURI = null;
        if (returnURI)
        {
            // get base URI of Portlet pointing to the return URI
            completeURI = portletRequest.getProvider().getReturnPortletURI( portletInstance,
                                                                            actionreference );
        }
        else
        {
            // get base URI of Portlet pointing to the given portlet, mode and state
            completeURI = portletRequest.getProvider().getPortletURI( portletInstance,
                                                                      state,
                                                                      actionreference );
        }

        // remove the anchor first

        int anchorIdx = completeURI.indexOf('#');

        if (anchorIdx != -1)
        {
            String uriTmp = completeURI.substring(0, anchorIdx);

            String anchorPart = completeURI.substring(anchorIdx);
            

            StringTokenizer st = new StringTokenizer(anchorPart, ";/?");
            if (st.hasMoreTokens())
                uriAnchor = st.nextToken();
            
            if (st.hasMoreTokens())
            {
                String afterAnchor = st.nextToken();
                
                int idx = completeURI.lastIndexOf(afterAnchor);
                completeURI = uriTmp + completeURI.substring(idx-1);
            }
            else
                completeURI = uriTmp;
            

        }

        // find protocol
        int idx = completeURI.indexOf("//");
        // find begin of path
        int pathIdx = completeURI.indexOf('/',idx+2);
        // find begin of parameters
        int parametersIdx = completeURI.indexOf('?',idx+2);
        // find begin of session id
        int sessionIdx = completeURI.indexOf(';',idx+2);


        // get host
        if ((pathIdx!=-1) && (parametersIdx!=-1) && (pathIdx>parametersIdx)) pathIdx = parametersIdx;
        else if ((pathIdx==-1) && (parametersIdx!=-1)) pathIdx = parametersIdx;
        if ((pathIdx!=-1) && (sessionIdx!=-1) && (pathIdx>sessionIdx)) pathIdx = sessionIdx;
        else if ((pathIdx==-1) && (sessionIdx!=-1)) pathIdx = sessionIdx;
        if (pathIdx==-1)
        {
            uriHost = completeURI;
            pathIdx = completeURI.length();
        }
        else uriHost = completeURI.substring(0,pathIdx);

        // get other parts of uri
        if ((parametersIdx==-1) && 
            (sessionIdx==-1))
        { // no parameters AND no session id
            uriPath = completeURI.substring(pathIdx);
        }
        else if (parametersIdx==-1)
        { // no parameters BUT session id
            uriPath = completeURI.substring(pathIdx,sessionIdx);
            uriSession = completeURI.substring(sessionIdx);
        }
        else if (sessionIdx==-1)
        { // no session id BUT parameters
            uriPath = completeURI.substring(pathIdx,parametersIdx);
            uriParameters = completeURI.substring(parametersIdx);
        }
        else
        { // there is both, the session id and the parameters
            // check if session id occurs before parameters
            if (sessionIdx<parametersIdx)
            {
                uriPath = completeURI.substring(pathIdx,sessionIdx);
                uriSession = completeURI.substring(sessionIdx,parametersIdx);
                uriParameters = completeURI.substring(parametersIdx);
            }
            else
            {
                // else, the parameters occur before the session id
                uriPath = completeURI.substring(pathIdx,parametersIdx);
                uriParameters = completeURI.substring(parametersIdx,sessionIdx);
                uriSession = completeURI.substring(sessionIdx);
            }
        }



    }
}