package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import org.apache.turbine.util.*;

import com.ibm.wps.portletcontainer.invoker.*;

import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class MessageEventImpl extends InstanceEventImpl implements MessageEvent
{
    private int messageStatus = 0;
    private PortletMessage message = null;

    public MessageEventImpl( PortletInstanceEntry entry,
                             PortletRequest request,
                             PortletMessage message )
    {
        super( entry, 
               request );
        this.message = message;
    }

    public PortletMessage getMessage ()
    {
        return message;
    }

    // additonal methods

    public void setMessageStatus(int messageStatus)
    {
        this.messageStatus = messageStatus;
    }

    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        PortletInvokerImpl invoker = (PortletInvokerImpl)evtEnv.getPortletInvoker();

        HttpServletRequest servletRequest = evtEnv.getServletRequest();
        
        HttpServletResponse servletResponse = evtEnv.getServletResponse();

        PortletRequestImpl portletRequest = (PortletRequestImpl)getRequest();

        PortletResponseImpl portletResponse = new PortletResponseImpl( getPortletInstanceEntry(),
                                                                       portletRequest,
                                                                       servletResponse,
                                                                       true );

        PortletConfig portletConfig = evtEnv.getPortletConfig(getPortletInstanceEntry().getConcretePortlet());

        PortletInvokerImpl.InternalPortletData data = 
            ((PortletInvokerImpl.EventEnvironmentImpl)evtEnv).getInternalPortletData(getPortletInstanceEntry().getConcretePortlet());

        try
        {
            portletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_MESSAGE_EVENT, 
                                        this);

            // include portlet by using request dispatcher
            invoker.include (org.apache.jetspeed.portlet.spi.Constants.METHOD_PERFORM_MESSAGE,
                             portletRequest,
                             portletResponse,
                             servletRequest, 
                             servletResponse, 
                             data);
        }
        catch (PortletException e)
        {
            String message = "PortletInvokerImpl.perform: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the message event.";
            Log.error(message, e);
            throw e; // rethrow
        }
        catch (java.io.IOException e)
        {
            String message = "PortletInvokerImpl.perform: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the message event.";
            Log.error(message, e);
            throw new PortletException(e); // rethrow
        }

    }

}