/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portletcontainer.service;

import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.service.*;
import org.apache.jetspeed.portlet.service.spi.*;

/**
 * simple PortletServiceFactory that just
 * instanciates the given class and
 * initializes it
 * 
 * @author Peter Fischer (peter.fischer@de.ibm.com)
 */
public class PortletServiceCacheFactory 
    implements org.apache.jetspeed.portlet.service.spi.PortletServiceFactory
{
    
    private Hashtable cache = new Hashtable();

    /**
     * createPortletServiceFactory instanciates the
     * given class and initializes it
     * 
     * @param service  the Class of the service
     * @param serviceProperties
     *               the properties from the registry that also
     *               contains the configuration of the PortletServices
     * @return the PortletService
     * @exception PortletServiceUnavailableException
     */
    public PortletService createPortletService(Class service, 
                                               Properties serviceProperties,
                                               ServletConfig servletConfig) 
                    throws PortletServiceUnavailableException {
        
        PortletServiceProvider ps  = null;

        ps = (PortletServiceProvider) cache.get(service.getName());

        if (ps != null) {
            return (PortletService) ps;
        }
        
        try {
            ps = (PortletServiceProvider) service.newInstance();
            ps.init(new PortletServiceConfigImpl(service, serviceProperties, servletConfig));
            cache.put(service.getName(), ps);
        } catch (InstantiationException ie) {
            org.apache.turbine.util.Log.
                warn("PortletServiceCacheFactory.createPortletService(Class, Properties): "+ie.toString(),ie);
            throw new PortletServiceUnavailableException();
        } catch (IllegalAccessException iae) {
            org.apache.turbine.util.Log.
                warn("PortletServiceCacheFactory.createPortletService(Class, Properties): "+iae.toString(),iae);
            throw new PortletServiceUnavailableException();
        }
        return (PortletService) ps;
    }
}
