package org.apache.jetspeed.portlets;

import org.xml.sax.SAXException;

import java.util.Map;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import java.io.StringWriter;
import java.util.Iterator;
import java.io.IOException;


public class TransformPortlet extends AbstractPortlet
{
    /**
     * Used internally to handle doing Xalan transfers directly.
     */
    protected String transform( StreamSource aContent,
                                StreamSource aStylesheet,
                                Map aParams) throws SAXException {


        // Have the XSLTProcessorFactory obtain a interface to a
        // new XSLTProcessor object.
        //XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
        /*
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor( new
            XercesLiaison() );

        if( params != null )
            {
                Iterator keys = params.keySet().iterator();
                while( keys.hasNext() )
                    {
                        String name  = (String) keys.next();
                        String value = (String) params.get(name);
                        processor.setStylesheetParam(name,
                                                     processor.createXString( value) );
                    }
            }

        StringWriter pw = new StringWriter();

        // Have the XSLTProcessor processor object transform "foo.xml" to
        // System.out, using the XSLT instructions found in "foo.xsl".
        processor.process( content,
                           stylesheet,
                           new XSLTResultTarget( pw ) );

*/
        StringWriter pw = new StringWriter();


        try
        {
            // 1. Instantiate the TransformerFactory.
            javax.xml.transform.TransformerFactory tFactory =
            javax.xml.transform.TransformerFactory.newInstance();
            // 2a. Get the stylesheet from the XML source.
            String media = null , title = null, charset = null;

            javax.xml.transform.Source stylesheet = tFactory.getAssociatedStylesheet
                                                    (aStylesheet,media, title, charset);

            // 2b. Process the stylesheet and generate a Transformer.
            Transformer transformer = tFactory.newTransformer(stylesheet);

            // 3. Use the Transformer to perform the transformation and send the
            //    the output to a Result object.

            transformer.transform ((aContent), new StreamResult (pw));

            pw.flush();
            pw.close();
        }
        catch (Exception e)
        {
            //should never really happen
            this.getPortletLog().error( e.toString() );
        }
        return pw.toString();
    }
}
