/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlets;

//Jetspeed stuff
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.service.*;
import org.apache.jetspeed.portlets.util.HTMLRewriter;
//import org.apache.jetspeed.cache.disk.*;


//standard java stuff
import java.net.*;
import java.util.*;
import java.io.*;


/**

@author <a href="mailto:rammer@sycom.at">Ingo Rammer</a>

 */
public class WebPagePortlet extends AbstractPortlet 
{


    private final static String URL_KEY = "url"; 

    private static String convertedString;  // parsed and re-written HTML

    public void init(PortletConfig config) throws UnavailableException
    {
        
	super.init(config);
        
	if(this.getPortletLog().isInfoEnabled())
	{
	    this.getPortletLog().info("WebPagePortlet:init! started");
	}

    }
    

    public void doView (PortletRequest request,
                         PortletResponse response) 
		throws PortletException,IOException
    {
        if (this.convertedString==null)
        {
            String htmlString; // original content
            try 
            {
                PortletContext context = getPortletConfig().getContext();
                ContentAccessService contentAccessService = (ContentAccessService)context.getService(
                    ContentAccessService.class);

                URL contentURL = contentAccessService.getURL( 
                    request.getPortletSettings().getAttribute(URL_KEY), request, response );

                htmlString = getContent(contentURL);

                if(this.getPortletLog().isDebugEnabled())
                {
                    this.getPortletLog().debug("WebPagePortlet:got URL from Diskcache" + htmlString);
                }

                convertedString = new HTMLRewriter(
                        ! getInitParameter("dont_remove_script","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_style","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_noscript","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_meta","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_applet","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_object","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_head","no")
                            .equalsIgnoreCase("yes"),
                        ! getInitParameter("dont_remove_onsomething","no")
                            .equalsIgnoreCase("yes")
                     ).convertURLs(htmlString,request.getPortletSettings().getAttribute(URL_KEY));


                if(this.getPortletLog().isInfoEnabled())
                {
                    this.getPortletLog().info("WebPagePortlet:init! ended");
                }    

            }
            catch (PortletServiceNotFoundException e)
            {
                getPortletLog().error("WebPagePortlet: ProxyPortletService not found",e);
                throw new PortletException("ProxyPortletService not found");
            }
            catch (PortletServiceUnavailableException e)
            {
                getPortletLog().error("WebPagePortlet: ProxyPortletService unavailable",e);
                throw new PortletException("ProxyPortletService unavailable");
            }
            catch (MalformedURLException e) 
            {
                this.getPortletLog().error("WebPagePortlet:MalformedURLException occurred:" + e.getMessage(),e);
                throw new PortletException( e.getMessage() );
            }
            catch (IOException e) 
            {
                this.getPortletLog().error("WebPagePortlet:IOException occurred:" + e.getMessage(),e);
                throw new PortletException( e.getMessage() );
            }
        }

	response.getWriter().println(this.convertedString);
    }

    
    private String getInitParameter(String name, String def_var)
    {
	String result;
        result = getPortletSettings().getAttribute(name);    
        if (result == null) 
        {
            result = def_var;
        }
        return result;
	
    }

    private String getContent(URL contentURL)
    {
        String content = "";
        try {
            HttpURLConnection conn = (HttpURLConnection)contentURL.openConnection();
            conn.setFollowRedirects(false);
            InputStream inStream = conn.getInputStream();
            int rc = 0;
            byte [] buffer = new byte[4096];
            while (rc >= 0)
            {
                if (rc>0)
                    content = content + new String(buffer,0,rc);
                rc = inStream.read(buffer);
            }
        }
        catch (java.io.IOException e)
        {
            this.getPortletLog().error("WebPagePortlet.getContent(URL): "+e.toString(),e);
            return "";
        }
        return content;
    }
}


