/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.gems.browser;

import java.util.List;

import javax.portlet.PortletRequest;


import org.apache.velocity.context.Context;

/**
 * Browser Query Fetch Interface
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: BrowserQuery.java 516448 2007-03-09 16:25:47Z ate $
 *
*/
public interface BrowserQuery
{

    /**
     * This method returns the query to be executed to get the results which will
     * be opened in the browser.
     *
     */
    public String getQueryString(PortletRequest request, Context context);

    /**
     * Filter the row programmatically on a query.
     * By returning true, instruct the database browser to filter the row.
     * By returning false, instruct the database browser to keep the row.
     * (Filtering means removing the row from the final result set).
     *
     * @param row The row being inspected for filtration.
     * @return True to filter the row, false to keep it.
     */
    public boolean filter(List row, PortletRequest request);

    /*
     * Set a list of JDBC query parameters.
     * All members of this list must be java objects (not primitives)
     * Should be called from derived classes.
     *
     */
    public void setSQLParameters(List parameters);

    public List getSQLParameters();


}