/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.beans;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.jetspeed.om.page.Document;

/**
 * DocumentBean
 * 
 * @version $Id: DocumentBean.java 920481 2010-03-08 19:51:56Z woonsan $
 */
@XmlRootElement(name="document")
public class DocumentBean extends NodeBean
{
    private static final long serialVersionUID = 1L;
    
    private String version;
    private boolean dirty;
    
    public DocumentBean()
    {
        
    }
    
    public DocumentBean(Document document)
    {
        super(document);
        version = document.getVersion();
        dirty = document.isDirty();
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    public boolean isDirty()
    {
        return dirty;
    }

    public void setDirty(boolean dirty)
    {
        this.dirty = dirty;
    }
    
}
